package com.thebeastshop.stock.dto;

import com.thebeastshop.stock.vo.SStockChannelVO;

import java.util.LinkedList;
import java.util.List;

/**
 * iPos 下的 SPV 库存详情查询对象
 *
 * @author Jun.Gong [jun.gong@thebeastshop.com]
 * @see com.thebeastshop.stock.dto.SIPosSpvStockDetailQuery
 * @see com.thebeastshop.stock.dto.SAbstractStockQueryDTO
 * @see com.thebeastshop.stock.dto.SAbstractSpvStockDetailQueryDTO
 * @since 1.7.6
 */
public class SIPosSpvStockDetailQueryDTO extends SAbstractSpvStockDetailQueryDTO<SIPosSpvStockDetailQueryDTO> implements SIPosSpvStockDetailQuery<SIPosSpvStockDetailQueryDTO>, SNonCombinedSpvStockQuery {

    /**
     * SKU 编号
     */
    private String skuCode;

    /**
     * 本店仓库渠道
     */
    private SStockChannelVO channel;

    /**
     * 配送仓渠道列表
     */
    private List<SStockChannelVO> dispatchChannels = new LinkedList<>();

    @Override
    public SStockChannelVO getChannel() {
        return channel;
    }

    public SIPosSpvStockDetailQueryDTO setChannel(SStockChannelVO channel) {
        this.channel = channel;
        return this;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public SIPosSpvStockDetailQueryDTO setSkuCode(String skuCode) {
        this.skuCode = skuCode;
        return this;
    }

    @Override
    public List<SStockChannelVO> getDispatchChannels() {
        return dispatchChannels;
    }

    public SIPosSpvStockDetailQueryDTO setDispatchChannels(List<SStockChannelVO> dispatchChannels) {
        this.dispatchChannels = dispatchChannels;
        return this;
    }
}
