package com.thebeastshop.stock.dto;

import com.thebeastshop.stock.vo.SStockChannelVO;

import java.util.LinkedList;
import java.util.List;

/**
 * iPos 下的 SPU 库存详情查询对象
 *
 * @author Jun.Gong [jun.gong@thebeastshop.com]
 * @see com.thebeastshop.stock.dto.SAbstractStockQueryDTO
 * @see com.thebeastshop.stock.dto.SAbstractSpuStockDetailQueryDTO
 * @since 1.7.6
 */
public class SIPosSpuStockDetailQueryDTO extends SAbstractSpuStockDetailQueryDTO<SIPosSpuStockDetailQueryDTO> {

    /**
     * 配送仓渠道列表
     */
    private List<SStockChannelVO> dispatchChannels = new LinkedList<>();

    public List<SStockChannelVO> getDispatchChannels() {
        return dispatchChannels;
    }

    public SIPosSpuStockDetailQueryDTO setDispatchChannels(List<SStockChannelVO> dispatchChannels) {
        this.dispatchChannels = dispatchChannels;
        return this;
    }

    /**
     * 添加配送仓渠道
     *
     * @param channel 库存渠道
     * @return
     */
    public SIPosSpuStockDetailQueryDTO addDispatchChannel(SStockChannelVO channel) {
        this.dispatchChannels.add(channel);
        return this;
    }

}

