package com.thebeastshop.stock.vo;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.stock.enums.SVirtualStockType;

import java.util.Date;

/**
 * 预售虚拟库存VO类
 * @author gongjun
 */
public class SVirtualStockVO extends BaseDO {

    private Long id;

    /**
     * 预售ID
     */
    private Long presaleId;

    /**
     * 库存类型 (如：权益库存)
     */
    private SVirtualStockType stockType;

    /**
     * SKU编号
     */
    private String skuCode;

    /**
     * 业务编号（如：权益号）
     */
    private String businessCode;

    /**
     * 业务所需库存总数
     */
    private Integer totalQuantity;

    /**
     * 已分配的业务库存数量
     */
    private Integer allottedQuantity;


    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPresaleId() {
        return presaleId;
    }

    public void setPresaleId(Long presaleId) {
        this.presaleId = presaleId;
    }

    public SVirtualStockType getStockType() {
        return stockType;
    }

    public void setStockType(SVirtualStockType stockType) {
        this.stockType = stockType;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public Integer getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(Integer totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public Integer getAllottedQuantity() {
        return allottedQuantity;
    }

    public void setAllottedQuantity(Integer allottedQuantity) {
        this.allottedQuantity = allottedQuantity;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
