package com.thebeastshop.stock.dto;


import com.thebeastshop.stock.vo.SStockChannelVO;

/**
 * 普通线上渠道下的 SPV 库存明细查询对象
 *
 * @author Jun.Gong [jun.gong@thebeastshop.com]
 * @since 1.7.6
 */
public class SSpvStockDetailQueryDTO extends SAbstractSpvStockDetailQueryDTO<SSpvStockDetailQueryDTO> implements SSpvStockDetailQuery, SNonCombinedSpvStockQuery  {

    /**
     * 商品渠道信息
     */
    private SStockChannelVO channel;

    /**
     * SKU 编号
     */
    private String skuCode;

    @Override
    public SStockChannelVO getChannel() {
        return channel;
    }

    public SSpvStockDetailQueryDTO setChannel(SStockChannelVO channel) {
        this.channel = channel;
        return this;
    }

    @Override
    public String getSkuCode() {
        return skuCode;
    }

    public SSpvStockDetailQueryDTO setSkuCode(String skuCode) {
        this.skuCode = skuCode;
        return this;
    }


}
