package com.thebeastshop.salesorder.vo;

import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.delivery.dto.RuleLimitDTO;
import com.thebeastshop.privilege.dto.FrontLimitProductDTO;
import com.thebeastshop.salesorder.dto.wechatGift.SoWechatGiftDto;
import com.thebeastshop.stock.dto.SGroupbuyOwnerOccupyDTO;
import com.thebeastshop.stock.dto.SGroupbuyParterOccupyDTO;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/***
 * 订单VO
 *
 * @author fs
 */
public class SoOrderVO implements Serializable{

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

    /**
     * 订单ID
     */
    private Long id;

    /**
     * 订单编号
     */
    private String code;

    /**
     * 订单来源渠道编码
     */
    private String channelCode;

    /**
     * 会员ID
     */
    private Long memberId;

    /**
     * 会员编码
     */
    private String memberCode;

    /**
     * 优惠券Code
     */
    private String couponCode;

    /**
     * 操作员ID
     */
    private Long createOperatorId;

    /**
     * 操作员名称
     */
    private String createOperatorName;

    /**
     * 食品特殊备注
     */
    private String foodSpecific;

    /**
     * 优惠券折扣金额
     */
    private BigDecimal couponDiscountAmount = BigDecimal.ZERO;;

    /**
     * 礼品卡支付金额
     */
    private BigDecimal giftCardAmount = BigDecimal.ZERO;

    /**
     * 礼品卡卡号,逗号分隔
     */
    private String giftCardDesc;

    /**
     * 储值抵扣金额
     */
    private BigDecimal accountAmount = BigDecimal.ZERO;

    /**
     * 礼品卡信息
     */
    private List<SoOrderGiftCardVO> soOrderGiftCardVOs = new ArrayList<>();

    /**
     * 集团订单关联的合同号
     */
    private String groupContractCode;

    /**
     * 内部备注
     */
    private String innerRemark;

    /**
     * 是否匿名发货 0否1是
     */
    private Integer isAnonymous;

    /**
     * 是否强制审单
     */
    private Integer isForceAudit;

    /**
     * 发票是否随同货物发送，0否1是
     */
    private Integer isInvoiceInSamePackage;

    /**
     * 是否需要发票 0否1是
     */
    private Integer needInvoice;

    /**
     * 用户备注
     */
    private String remark;

    /**
     * 订单类型，1渠道销售单2渠道换货单3集团订单11礼品订单12样品订单
     */
    private Integer salesOrderType;

    /**
     * 发票
     */
    private SoInvoiceInfoVO soInvoiceInfoVO;

    /**
     * 身份证信息
     */
    private SoIdentityCardVO soIdentityCardVO;

    /**
     * 跨境购标注 0普通１跨境购
     */
    private Integer crossBorderFlag;

    /**
     * 积分
     */
    private BigDecimal pointOnLine = BigDecimal.ZERO;

    /**
     * 积分抵扣
     */
    private BigDecimal pointOnLineDeduction = BigDecimal.ZERO;

    /**
     * 服务费
     */
    private BigDecimal serviceFeeAmount = BigDecimal.ZERO;

    /**
     * 总价
     */
    private BigDecimal totalAmount = BigDecimal.ZERO;

    /**
     * 订单头折扣
     */
    private BigDecimal discountOnHead = BigDecimal.ZERO;

    /**
     * 订单行折扣汇总
     */
    private BigDecimal discountOnLine = BigDecimal.ZERO;

    /**
     * 折扣后总价
     */
    private BigDecimal totalAmountAfterDiscount = BigDecimal.ZERO;;

    /**
     * 海淘运输费用
     */
    private BigDecimal crossFree = BigDecimal.ZERO;

    /**
     * 实付金额
     */
	private BigDecimal actualPayFee = BigDecimal.ZERO;

    /**
     * 实付积分数额
     */
	private BigDecimal actualPayPoint = BigDecimal.ZERO;

    /**
     * APP下载来源
     */
	private String downloadSource;

	/**
     * 生日优惠折扣
     */
    private BigDecimal birthdayDiscount = BigDecimal.ZERO;

    /**
     * 生日折扣金额
     */
    private BigDecimal birthdayDiscountAmount = BigDecimal.ZERO;

    /**
     * 基金返还金额
     */
    private BigDecimal fundReturnAmount = BigDecimal.ZERO;

    /**
     * 基金支付金额
     */
    private BigDecimal fundPayAmount = BigDecimal.ZERO;

    /**
     * 是否使用生日折扣
     */
    private boolean useBdayDiscount = false;

	/**
	 * 订单类型,1月送鲜花，2 凑钱 3 买赠 4 定制，5配方定制 6浦发 10 团购
	 */
	private int orderType = 0;

	/**
	 * 限时送达费用
	 */
	private BigDecimal limitFee = BigDecimal.ZERO;

	/**
	 * 运费
	 */
	private BigDecimal carriage = BigDecimal.ZERO;

    /**
     * 系统计算运费（用于落单后和手填运费对比）
     */
    private BigDecimal calDeliverPostageAmount = BigDecimal.ZERO;

	/**
	 * 权益Id
	 */
	private String interestsId;

	/**
	 * 定制费
	 */
	private BigDecimal customizationAmount = BigDecimal.ZERO;

	/**
	 * 定制折扣
	 */
	private BigDecimal customizationDiscount = BigDecimal.ZERO;

	/**
	 * 设备Id
	 */
	private String deviceId;

	/**
	 * 投放来源
	 */
	private String utmSource;

    /**
     * 订单组合商品信息
     */
    private List<SoOrderCombinationVO> soOrderCombinations;

    /**
     * 商品类目
     */
    private List<Integer> categoryIds;

    /**
     * 支付交易流水号
     */
    private String tradeNo;
    
    /**
     * true:开团，fase:参团
     */
    private boolean isGroupbuy = true;
    
	/**
	 * 平台
	 */
	private String tbsClient;

	/**
	 * 投放渠道
	 */
	private String tbsUSource;

	/**
	 * 系统
	 */
	private String platForm;

    /**
     * 收货人
     */
    private String Receiver;

    /**
     * 收货人电话
     */
    private String receiverPhone;

    /**
     * 订单包裹
     */
    private List<SoPackageVO> opSoPackageVOs;

    /**
     * 开团信息
     */
    private SGroupbuyOwnerOccupyDTO sGroupbuyOwnerOccupyDTO;

    /**
     * 参团信息
     */
    private SGroupbuyParterOccupyDTO sGroupbuyParterOccupyDTO;
    
	/**
	 *  抢购
	 */
	private List<CampaignStreamVO> panicVos;

	/**
	 *  换购或买赠
	 */
	private List<CampaignStreamVO> additionalLimitVos;
	
	/**
	 *  抢购
	 */
	private List<CampaignStreamVO> priceDiscountVos;

    /**
     * 商品限量
     */
    private FrontLimitProductDTO productLimitDto;

    /**
     * 运费规则
     */
	private RuleLimitDTO limitRegionVo;

    /**
     * 微信送礼
     */
    private SoWechatGiftDto soWechatGiftDto;

    /**
     * 购买的礼品卡信息
     */
    private List<SalesGiftCardVO> salesGiftCardVOS;

    /**
     * 是否生成取货码
     */
    private boolean genPickupCode = false;

    public List<CampaignStreamVO> getPriceDiscountVos() {
		return priceDiscountVos;
	}

	public void setPriceDiscountVos(List<CampaignStreamVO> priceDiscountVos) {
		this.priceDiscountVos = priceDiscountVos;
	}

    public FrontLimitProductDTO getProductLimitDto() {
        return productLimitDto;
    }

    public void setProductLimitDto(FrontLimitProductDTO productLimitDto) {
        this.productLimitDto = productLimitDto;
    }

    public String getDeviceId() {
		return deviceId;
	}

	public void setDeviceId(String deviceId) {
		this.deviceId = deviceId;
	}

	public String getInterestsId() {
		return interestsId;
	}

	public void setInterestsId(String interestsId) {
		this.interestsId = interestsId;
	}

	public String getDownloadSource() {
		return downloadSource;
	}

	public void setDownloadSource(String downloadSource) {
		this.downloadSource = downloadSource;
	}
   
    public String getChannelCode() {
        return channelCode;
    }

    public String getCode() {
        return code;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public BigDecimal getCouponDiscountAmount() {
        return couponDiscountAmount;
    }

    public Long getCreateOperatorId() {
        return createOperatorId;
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public BigDecimal getDiscountOnHead() {
        return discountOnHead;
    }

    public String getFoodSpecific() {
        return foodSpecific;
    }

    public BigDecimal getGiftCardAmount() {
        return giftCardAmount;
    }

    public String getGiftCardDesc() {
        return giftCardDesc;
    }

    public String getGroupContractCode() {
        return groupContractCode;
    }

    public Long getId() {
        return id;
    }

    public String getInnerRemark() {
        return innerRemark;
    }

    public Integer getIsAnonymous() {
        return isAnonymous;
    }

    public Integer getIsForceAudit() {
        return isForceAudit;
    }

    public Integer getIsInvoiceInSamePackage() {
        return isInvoiceInSamePackage;
    }

    public Long getMemberId() {
        return memberId;
    }

    public Integer getNeedInvoice() {
        return needInvoice;
    }

    public String getRemark() {
        return remark;
    }

    public Integer getSalesOrderType() {
        return salesOrderType;
    }

    public BigDecimal getServiceFeeAmount() {
        return serviceFeeAmount;
    }
  
    public SoInvoiceInfoVO getSoInvoiceInfoVO() {
        return soInvoiceInfoVO;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public BigDecimal getTotalAmountAfterDiscount() {
        return totalAmountAfterDiscount;
    }

    public void setChannelCode(final String channelCode) {
        this.channelCode = channelCode;
    }

    public void setCode(final String code) {
        this.code = code;
    }

    public void setCouponCode(final String couponCode) {
        this.couponCode = couponCode;
    }

    public void setCouponDiscountAmount(final BigDecimal couponDiscountAmount) {
        this.couponDiscountAmount = couponDiscountAmount;
    }

    public void setCreateOperatorId(final Long createOperatorId) {
        this.createOperatorId = createOperatorId;
    }

    public void setCreateOperatorName(final String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public void setDiscountOnHead(final BigDecimal discountOnHead) {
        this.discountOnHead = discountOnHead;
    }

    public void setFoodSpecific(final String foodSpecific) {
        this.foodSpecific = foodSpecific;
    }

    public void setGiftCardAmount(final BigDecimal giftCardAmount) {
        this.giftCardAmount = giftCardAmount;
    }

    public void setGiftCardDesc(final String giftCardDesc) {
        this.giftCardDesc = giftCardDesc;
    }

    public void setGroupContractCode(final String groupContractCode) {
        this.groupContractCode = groupContractCode;
    }

    public void setId(final Long id) {
        this.id = id;
    }

    public void setInnerRemark(final String innerRemark) {
        this.innerRemark = innerRemark;
    }

    public void setIsAnonymous(final Integer isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    public void setIsForceAudit(final Integer isForceAudit) {
        this.isForceAudit = isForceAudit;
    }

    public void setIsInvoiceInSamePackage(final Integer isInvoiceInSamePackage) {
        this.isInvoiceInSamePackage = isInvoiceInSamePackage;
    }

    public void setMemberId(final Long memberId) {
        this.memberId = memberId;
    }

    public void setNeedInvoice(final Integer needInvoice) {
        this.needInvoice = needInvoice;
    }


    public void setRemark(final String remark) {
        this.remark = remark;
    }

    public void setSalesOrderType(final Integer salesOrderType) {
        this.salesOrderType = salesOrderType;
    }

    public void setServiceFeeAmount(final BigDecimal serviceFeeAmount) {
        this.serviceFeeAmount = serviceFeeAmount;
    }

    public void setSoInvoiceInfoVO(final SoInvoiceInfoVO soInvoiceInfoVO) {
        this.soInvoiceInfoVO = soInvoiceInfoVO;
    }

    public void setTotalAmount(final BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setTotalAmountAfterDiscount(final BigDecimal totalAmountAfterDiscount) {
        this.totalAmountAfterDiscount = totalAmountAfterDiscount;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(final Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public BigDecimal getCrossFree() {
        return crossFree;
    }

    public void setCrossFree(final BigDecimal crossFree) {
        this.crossFree = crossFree;
    }

	public BigDecimal getDiscountOnLine() {
		return discountOnLine;
	}

	public void setDiscountOnLine(BigDecimal discountOnLine) {
		this.discountOnLine = discountOnLine;
	}

	public BigDecimal getBirthdayDiscount() {
		return birthdayDiscount;
	}

	public void setBirthdayDiscount(BigDecimal birthdayDiscount) {
		this.birthdayDiscount = birthdayDiscount;
	}

	public BigDecimal getActualPayFee() {
		return actualPayFee;
	}

	public void setActualPayFee(BigDecimal actualPayFee) {
		this.actualPayFee = actualPayFee;
	}

	public BigDecimal getBirthdayDiscountAmount() {
		return birthdayDiscountAmount;
	}

	public void setBirthdayDiscountAmount(BigDecimal birthdayDiscountAmount) {
		this.birthdayDiscountAmount = birthdayDiscountAmount;
	}

    public BigDecimal getFundReturnAmount() {
        return fundReturnAmount;
    }

    public void setFundReturnAmount(BigDecimal fundReturnAmount) {
        this.fundReturnAmount = fundReturnAmount;
    }

    public BigDecimal getFundPayAmount() {
        return fundPayAmount;
    }

    public void setFundPayAmount(BigDecimal fundPayAmount) {
        this.fundPayAmount = fundPayAmount;
    }

    public BigDecimal getLimitFee() {
		return limitFee;
	}

	public void setLimitFee(BigDecimal limitFee) {
		this.limitFee = limitFee;
	}

	public BigDecimal getCarriage() {
		return carriage;
	}

	public void setCarriage(BigDecimal carriage) {
		this.carriage = carriage;
	}

    public BigDecimal getCalDeliverPostageAmount() {
        return calDeliverPostageAmount;
    }

    public void setCalDeliverPostageAmount(BigDecimal calDeliverPostageAmount) {
        this.calDeliverPostageAmount = calDeliverPostageAmount;
    }

    public BigDecimal getCustomizationAmount() {
		return customizationAmount;
	}

	public void setCustomizationAmount(BigDecimal customizationAmount) {
		this.customizationAmount = customizationAmount;
	}

	public BigDecimal getCustomizationDiscount() {
		return customizationDiscount;
	}

	public void setCustomizationDiscount(BigDecimal customizationDiscount) {
		this.customizationDiscount = customizationDiscount;
	}

	public String getUtmSource() {
		return utmSource;
	}

	public void setUtmSource(String utmSource) {
		this.utmSource = utmSource;
	}

	public boolean isUseBdayDiscount() {
		return useBdayDiscount;
	}

	public void setUseBdayDiscount(boolean useBdayDiscount) {
		this.useBdayDiscount = useBdayDiscount;
	}
	
	public int getOrderType() {
		return orderType;
	}

	public void setOrderType(int orderType) {
		this.orderType = orderType;
	}

	public List<Integer> getCategoryIds() {
		return categoryIds;
	}

	public void setCategoryIds(List<Integer> categoryIds) {
		this.categoryIds = categoryIds;
	}
	
	public BigDecimal getPointOnLineDeduction() {
		return pointOnLineDeduction;
	}

	public void setPointOnLineDeduction(BigDecimal pointOnLineDeduction) {
		this.pointOnLineDeduction = pointOnLineDeduction;
	}

	public BigDecimal getPointOnLine() {
		return pointOnLine;
	}

	public void setPointOnLine(BigDecimal pointOnLine) {
		this.pointOnLine = pointOnLine;
	}

	public String getTradeNo() {
		return tradeNo;
	}

	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}

	public boolean isGroupbuy() {
		return isGroupbuy;
	}

	public void setGroupbuy(boolean isGroupbuy) {
		this.isGroupbuy = isGroupbuy;
	}

	public String getTbsClient() {
		return tbsClient;
	}

	public void setTbsClient(String tbsClient) {
		this.tbsClient = tbsClient;
	}

	public String getTbsUSource() {
		return tbsUSource;
	}

	public void setTbsUSource(String tbsUSource) {
		this.tbsUSource = tbsUSource;
	}

	public String getPlatForm() {
		return platForm;
	}

	public void setPlatForm(String platForm) {
		this.platForm = platForm;
	}

	public List<SoOrderGiftCardVO> getSoOrderGiftCardVOs() {
		return soOrderGiftCardVOs;
	}

	public void setSoOrderGiftCardVOs(List<SoOrderGiftCardVO> soOrderGiftCardVOs) {
		this.soOrderGiftCardVOs = soOrderGiftCardVOs;
	}

	public List<SoOrderCombinationVO> getSoOrderCombinations() {
		return soOrderCombinations;
	}

	public void setSoOrderCombinations(List<SoOrderCombinationVO> soOrderCombinations) {
		this.soOrderCombinations = soOrderCombinations;
	}

	public SoIdentityCardVO getSoIdentityCardVO() {
		return soIdentityCardVO;
	}

	public void setSoIdentityCardVO(SoIdentityCardVO soIdentityCardVO) {
		this.soIdentityCardVO = soIdentityCardVO;
	}

	public BigDecimal getActualPayPoint() {
		return actualPayPoint;
	}

	public void setActualPayPoint(BigDecimal actualPayPoint) {
		this.actualPayPoint = actualPayPoint;
	}

	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public List<SoPackageVO> getOpSoPackageVOs() {
		return opSoPackageVOs;
	}

	public void setOpSoPackageVOs(List<SoPackageVO> opSoPackageVOs) {
		this.opSoPackageVOs = opSoPackageVOs;
	}

	public SGroupbuyOwnerOccupyDTO getsGroupbuyOwnerOccupyDTO() {
		return sGroupbuyOwnerOccupyDTO;
	}

	public void setsGroupbuyOwnerOccupyDTO(SGroupbuyOwnerOccupyDTO sGroupbuyOwnerOccupyDTO) {
		this.sGroupbuyOwnerOccupyDTO = sGroupbuyOwnerOccupyDTO;
	}

	public SGroupbuyParterOccupyDTO getsGroupbuyParterOccupyDTO() {
		return sGroupbuyParterOccupyDTO;
	}

	public void setsGroupbuyParterOccupyDTO(SGroupbuyParterOccupyDTO sGroupbuyParterOccupyDTO) {
		this.sGroupbuyParterOccupyDTO = sGroupbuyParterOccupyDTO;
	}

	public List<CampaignStreamVO> getPanicVos() {
		return panicVos;
	}

	public void setPanicVos(List<CampaignStreamVO> panicVos) {
		this.panicVos = panicVos;
	}

    public List<CampaignStreamVO> getAdditionalLimitVos() {
        return additionalLimitVos;
    }

    public void setAdditionalLimitVos(List<CampaignStreamVO> additionalLimitVos) {
        this.additionalLimitVos = additionalLimitVos;
    }

	public String getReceiver() {
		return Receiver;
	}

	public void setReceiver(String receiver) {
		Receiver = receiver;
	}

	public String getReceiverPhone() {
		return receiverPhone;
	}

	public void setReceiverPhone(String receiverPhone) {
		this.receiverPhone = receiverPhone;
	}

	public RuleLimitDTO getLimitRegionVo() {
		return limitRegionVo;
	}

	public void setLimitRegionVo(RuleLimitDTO limitRegionVo) {
		this.limitRegionVo = limitRegionVo;
	}

    public BigDecimal getAccountAmount() {
        return accountAmount;
    }

    public void setAccountAmount(BigDecimal accountAmount) {
        this.accountAmount = accountAmount;
    }

    public SoWechatGiftDto getSoWechatGiftDto() {
        return soWechatGiftDto;
    }

    public void setSoWechatGiftDto(SoWechatGiftDto soWechatGiftDto) {
        this.soWechatGiftDto = soWechatGiftDto;
    }

    public List<SalesGiftCardVO> getSalesGiftCardVOS() {
        return salesGiftCardVOS;
    }

    public void setSalesGiftCardVOS(List<SalesGiftCardVO> salesGiftCardVOS) {
        this.salesGiftCardVOS = salesGiftCardVOS;
    }

    public boolean isGenPickupCode() {
        return genPickupCode;
    }

    public void setGenPickupCode(boolean genPickupCode) {
        this.genPickupCode = genPickupCode;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
