package com.thebeastshop.salesorder.enums;

/**
 * @ClassName: SoWechatGiftStatusEnum
 * @Description: 微信送礼状态
 * @Author xiang.gao
 * @Date 2022/12/29 14:25
 */
public enum SoWechatGiftStatusEnum {

    UNPAID(0, "未支付"),
    WAIT_RECEIVE(1, "待领取"),
    RECEIVED(2, "已领取"),
    EXPIRED(3, "已过期"),
    CANCELED(4,"已取消");

    private Integer id;
    private String name;

    SoWechatGiftStatusEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static SoWechatGiftStatusEnum getEnumById(Integer id) {
        for (SoWechatGiftStatusEnum e : SoWechatGiftStatusEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }
}
