/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.exception;

/***
 * 渠道错误码
 * @author fs
 *
 */
public class SalesOrderExceptionErrorCode {

    private static final String ERROR_CODE_PREFIX                          = "SO";

    /**
     * 通用
     */
    // 参数异常
    public static final String ILLEGAL_PARAM = ERROR_CODE_PREFIX + "0001";

    // 状态与预期不符
    public static final String STATUS_NOT_EXPECTED = ERROR_CODE_PREFIX + "0002";

    // 版本与预期不符
    public static final String VERSION_NOT_EXPECTED = ERROR_CODE_PREFIX + "0003";

    // 结果与预期不符
    public static final String RESULT_NOT_EXPECTED = ERROR_CODE_PREFIX + "0004";



    //用户名或密码错误
    public static final String MEMBER_PASSWORD_WRONG_CODE = ERROR_CODE_PREFIX + "1001";
    //用户被禁用
    public static final String MEMBER_STATUS_UNAVAILABLE_CODE = ERROR_CODE_PREFIX + "1002";
  
    //用户已存在
    public static final String MEMBER_ALREADY_EXISTS_CODE = ERROR_CODE_PREFIX + "1003";

    //用户修改错误
    public static final String MEMBER_MODIFY_CODE = ERROR_CODE_PREFIX + "1006";
    
    //订单金额不能为0
    public static final String ORDER_AMOUNT_ZERO_CODE = ERROR_CODE_PREFIX + "2001";
    //coupon无效
    public static final String COUPON_INVALID_CODE = ERROR_CODE_PREFIX + "2002";

    //第三方渠道连接超时
    public static final String CONNECT_TIMED_OUT = ERROR_CODE_PREFIX + "3001";
    
    //库存不足
    public static final String ORDER_QUANTITY_ZERO_CODE = ERROR_CODE_PREFIX + "4001";
}