package com.thebeastshop.salesorder.vo.pub;

import com.thebeastshop.common.BaseDO;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SoPsPackageVO extends BaseDO {

    /**
     * 包裹ID
     */
    private Long id;
    /**
     * 订单ID
     */
    private Long salesOrderId;
    /**
     * 包裹编码
     */
    private String code;
    /**
     * 包裹配送仓库编码
     */
    private String dispatchWarehouseCode;
    /**
     * 配送方式，0非快递1快递
     */
    private Integer deliveryType;
    /**
     * 限时配送时间
     */
    private String limitDeliveryTimeDesc;
    /**
     * 卡片类型
     */
    private Integer cardType;
    /**
     * 卡片内容
     */
    private String cardContent;
    /**
     * 期望送达日期
     */
    private Date expectReceiveDate;
    /**
     * 计划发货时间
     */
    private Date planedDeliveryDate;
    /**
     * 包裹状态说明
     */
    private Integer packageStatus;
    /**
     * 发货时间
     */
    private Date deliveryTime;
    /**
     * 制单时间
     */
    private Date orderMakeTime;
    /**
     * 收货时间
     */
    private Date receiveTime;
    /**
     * 天猫子订单ID
     */
    private Long oid;
    /**
     * 跨境购标注 0普通１跨境购
     */
    private Integer crossBorderFlag = 0;
    /**
     * 备注
     */
    private String remark;
    /**
     * 通关方式（0：未知，1：BC，2：个人）
     */
    private Short clearanceWay = 0;
    /**
     * 0:普通 1：海淘  2:预售 3:鲜花 4:代销,5,6
     */
    private Integer packageType = 0;
    /**
     * 卡名From
     */
    private String cardFrom;
    /**
     * 卡名To
     */
    private String cardTo;
    /**
     * 商品列表
     */
    private List<SoPsPackageSkuVO> packageSkuVOs = new ArrayList<SoPsPackageSkuVO>();
    /**
     * 收货地址
     */
    private SoPsPackageDeliveryInfoVO soPsPackageDeliveryInfoVO;

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getOid() {
        return oid;
    }

    public void setOid(Long oid) {
        this.oid = oid;
    }

    public String getCardContent() {
        return cardContent;
    }

    public Integer getCardType() {
        return cardType;
    }

    public String getCode() {
        return code;
    }


    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public String getDispatchWarehouseCode() {
        return dispatchWarehouseCode;
    }

    public Date getExpectReceiveDate() {
        return expectReceiveDate;
    }


    public String getLimitDeliveryTimeDesc() {
        return limitDeliveryTimeDesc;
    }


    public SoPsPackageDeliveryInfoVO getSoPsPackageDeliveryInfoVO() {
        return soPsPackageDeliveryInfoVO;
    }


    public List<SoPsPackageSkuVO> getPackageSkuVOs() {
        return packageSkuVOs;
    }


    public Integer getPackageStatus() {
        return packageStatus;
    }


    public Date getPlanedDeliveryDate() {
        return planedDeliveryDate;
    }


    public void setCardContent(String cardContent) {
        this.cardContent = cardContent;
    }


    public void setCardType(Integer cardType) {
        this.cardType = cardType;
    }


    public void setCode(String code) {
        this.code = code;
    }


    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public void setDispatchWarehouseCode(String dispatchWarehouseCode) {
        this.dispatchWarehouseCode = dispatchWarehouseCode;
    }

    public void setExpectReceiveDate(Date expectReceiveDate) {
        this.expectReceiveDate = expectReceiveDate;
    }


    public void setLimitDeliveryTimeDesc(String limitDeliveryTimeDesc) {
        this.limitDeliveryTimeDesc = limitDeliveryTimeDesc;
    }


    public void setSoPsPackageDeliveryInfoVO(SoPsPackageDeliveryInfoVO soPsPackageDeliveryInfoVO) {
        this.soPsPackageDeliveryInfoVO = soPsPackageDeliveryInfoVO;
    }


    public void setPackageSkuVOs(List<SoPsPackageSkuVO> packageSkuVOs) {
        this.packageSkuVOs = packageSkuVOs;
    }


    public void setPackageStatus(Integer packageStatus) {
        this.packageStatus = packageStatus;
    }


    public void setPlanedDeliveryDate(Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public Short getClearanceWay() {
        return clearanceWay;
    }

    public void setClearanceWay(Short clearanceWay) {
        this.clearanceWay = clearanceWay;
    }

    public Integer getPackageType() {
        return packageType;
    }

    public void setPackageType(Integer packageType) {
        this.packageType = packageType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }


    public Date getOrderMakeTime() {
        return orderMakeTime;
    }

    public void setOrderMakeTime(Date orderMakeTime) {
        this.orderMakeTime = orderMakeTime;
    }

    public Date getReceiveTime() {
        return receiveTime;
    }

    public void setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
    }

    public String getCardFrom() {
        return cardFrom;
    }

    public void setCardFrom(String cardFrom) {
        this.cardFrom = cardFrom;
    }

    public String getCardTo() {
        return cardTo;
    }

    public void setCardTo(String cardTo) {
        this.cardTo = cardTo;
    }

    public Long getSalesOrderId() {
        return salesOrderId;
    }

    public void setSalesOrderId(Long salesOrderId) {
        this.salesOrderId = salesOrderId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("code", code)
                .append("dispatchWarehouseCode", dispatchWarehouseCode)
                .append("deliveryType", deliveryType)
                .append("limitDeliveryTimeDesc", limitDeliveryTimeDesc)
                .append("cardType", cardType)
                .append("cardContent", cardContent)
                .append("expectReceiveDate", expectReceiveDate)
                .append("planedDeliveryDate", planedDeliveryDate)
                .append("packageStatus", packageStatus)
                .append("deliveryTime", deliveryTime)
                .append("oid", oid)
                .append("crossBorderFlag", crossBorderFlag)
                .append("remark", remark)
                .append("clearanceWay", clearanceWay)
                .append("packageType", packageType)
                .append("packageSkuVOs", packageSkuVOs)
                .append("soPsPackageDeliveryInfoVO", soPsPackageDeliveryInfoVO)
                .toString();
    }
}
