/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.vo.inner;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.salesorder.enums.SoPackageDeliveryTitleEnum;

import java.io.Serializable;

/**
 * @author Eric.Lou
 * @version $Id: OpSoDeliveryInfoVO.java, v 0.1 2015-08-17 12:02
 */
public class SoInPackageDeliveryInfoVO extends BaseDO {

    // constructor
    public SoInPackageDeliveryInfoVO() {

    }

    // original
    private Long id;

    private Long packageId;

    private Long districtId;

    private String address;

    private String zipCode;

    private String circuitDesc;

    private String companyName;

    private Integer title;

    private String receiver;

    private String receiverPhone;

    private String deliveryCode;

    private Integer expressType;

    private Integer isEbill;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

    // self

    String districtName;

    // manual generate
/*
    pub String getDistrictName() {
        if (EmptyUtil.isNotEmpty(districtId)) {
            CommDistrict commDistrict = PegasusUtilFacade.getInstance().findDistrictById(districtId);
            if (EmptyUtil.isNotEmpty(commDistrict)) {
                return commDistrict.getFullName();
            }
        }
        return "";
    }
*/

/*
    pub String getExpressTypeName() {
        String name = "";
        if(expressType != null){
            WhWmsExpressInfo whWmsExpressInfo = PegasusWarehouseServiceFacade.getInstance().findExpressInfoById(Long.parseLong(expressType.toString()));
            if(whWmsExpressInfo != null){
                return whWmsExpressInfo.getName();
            }
        }
        return name;
    }
*/
/*
    pub String getExpressTypeNameForSms() {
        String name = "";
        if(expressType != null){
            WhWmsExpressInfo whWmsExpressInfo = PegasusWarehouseServiceFacade.getInstance().findExpressInfoById(Long.parseLong(expressType.toString()));
            if(whWmsExpressInfo != null){
                return whWmsExpressInfo.getFullName();
            }
        }
        return name;
    }
*/
    public String getTitleName(){
        if (title == null) return "未导出";
        SoPackageDeliveryTitleEnum soPackageDeliveryInfoVO = SoPackageDeliveryTitleEnum.getEnumById(title);
        if (soPackageDeliveryInfoVO == null) return "未导出";
        return soPackageDeliveryInfoVO.getName();
    }

    // auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPackageId() {
        return packageId;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public Long getDistrictId() {
        return districtId;
    }

    public void setDistrictId(Long districtId) {
        this.districtId = districtId;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getCircuitDesc() {
        return circuitDesc;
    }

    public void setCircuitDesc(String circuitDesc) {
        this.circuitDesc = circuitDesc;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getTitle() {
        return title;
    }

    public void setTitle(Integer title) {
        this.title = title;
    }

    public String getReceiver() {
        return receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public String getReceiverPhone() {
        return receiverPhone;
    }

    public void setReceiverPhone(String receiverPhone) {
        this.receiverPhone = receiverPhone;
    }

    public String getDeliveryCode() {
        return deliveryCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public Integer getExpressType() {
        return expressType;
    }

    public void setExpressType(Integer expressType) {
        this.expressType = expressType;
    }

    public Integer getIsEbill() {
        return isEbill;
    }

    public void setIsEbill(Integer isEbill) {
        this.isEbill = isEbill;
    }

    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

}
