package com.thebeastshop.salesorder.service;

import java.util.List;
import java.util.Map;

import com.thebeastshop.salesorder.vo.SoInvoiceInfoVO;
import com.thebeastshop.salesorder.vo.pub.SoOrderPayItemVO;
import com.thebeastshop.salesorder.vo.pub.SoOrderPayVO;

public interface SoPsOrderPayService {

	
    int insertSelective(SoOrderPayItemVO record);

    int insertSelectives(List<SoOrderPayItemVO> records);
    
    SoOrderPayItemVO findById(Integer Id);
    
    List<SoOrderPayItemVO> findByOrderId(Integer orderId);

    List<SoOrderPayItemVO> findByOrderId(Integer orderId,Integer status);
    
    int update(SoOrderPayItemVO record);

    int deleteByOrderId(Integer orderId);

    boolean updateOrderStatusByPayment(SoOrderPayItemVO payVo);

    boolean updateGrouponOrderStatus(Map<String, List<String>> groupMap, Boolean isSuccess);
	
	SoOrderPayVO findSoOrderPayByOrderId(Integer orderId);
	
	SoOrderPayVO findSoOrderPayByOrderCode(String orderCode);
	
	Integer getPaymentType(Integer paymentChannel);
	
	void setOrderPromotion(Long id);
	
	List<SoInvoiceInfoVO> getSoInvoiceInfoVOs(Long orderId);
	
	boolean checkOrderPayForUpdateStatus(String orderCode);
}
