/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: ReturnOrExchangeSku.java, v 0.1 2015-08-27 11:53
 */
public class SoReturnSkuVO implements Serializable {

    // constructor
    public SoReturnSkuVO() {

    }

    // self
    private String skuCode;//SKU编码

    private String skuName;//SKU名称

    private String skuNameCn;//SKU中文名称

    private Integer quantity;//退货数量（参与退款运算）

    private Integer needToReturnQuantity;//实际需要退回的数量（仓库待入库指令中的数量）

    private Integer needToReturnAcceptedQuantity=0;//实际退回的良品

    private Integer needToReturnDamageQuantity=0;//实际退回的残次

    private Integer alreadySendQuantity;//已发货的数量

    private Integer alreadyReturnQuantity;//已退货的数量

    private BigDecimal unitRefundAmount;//购买时候单个最终价格

    private BigDecimal unitPrice;//购买时候单个原价

    private List<SoExchangeSkuVO> exchangeSkuList;//可换SKU列表

    private String selExchangeSkuCode;//选中的换货SKU

    private Integer selExchangeSkuIsJit;//选中的换货SKU是否JIT
    
    private Integer isGift;//是否赠品
    
    private Long presaleId;//预售ID，为null则是非预售

    private String clearanWay;  //通关方式 BC、个人
    private Long productId;

    private Long spvId;

    private String comId;

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    private BigDecimal aptUGiftCardAmount;			// 礼品卡金额分摊到单品

    public String getClearanWay() {
        return clearanWay;
    }

    public void setClearanWay(String clearanWay) {
        this.clearanWay = clearanWay;
    }

    public Integer getIsGift() {
		return isGift;
	}

	public void setIsGift(Integer isGift) {
		this.isGift = isGift;
	}

	public Long getPresaleId() {
		return presaleId;
	}

	public void setPresaleId(Long presaleId) {
		this.presaleId = presaleId;
	}

	// manual generate
    public Integer getCanReturnQuantity() {
        return alreadySendQuantity - alreadyReturnQuantity;
    }

    public BigDecimal getTotalRefundAmount() {
        return new BigDecimal(quantity == null ? 0 : quantity).multiply(unitRefundAmount == null ? new BigDecimal(0) : unitRefundAmount);
    }

    public void addExchangeSku(SoExchangeSkuVO exchangeSku) {
        if (exchangeSkuList == null) {
            exchangeSkuList = new ArrayList<SoExchangeSkuVO>();
        }
        Boolean find = false;
        for (SoExchangeSkuVO sku : exchangeSkuList) {
            if (exchangeSku.getSkuCode().equals(sku.getSkuCode())) {
                find = true;
            }
        }
        if (!find) {
            exchangeSkuList.add(exchangeSku);
        }
    }

    // auto generate
    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getSkuNameCn() {
        return skuNameCn;
    }

    public void setSkuNameCn(String skuNameCn) {
        this.skuNameCn = skuNameCn;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Integer getNeedToReturnQuantity() {
        return needToReturnQuantity;
    }

    public void setNeedToReturnQuantity(Integer needToReturnQuantity) {
        this.needToReturnQuantity = needToReturnQuantity;
    }

    public Integer getNeedToReturnAcceptedQuantity() {
        return needToReturnAcceptedQuantity;
    }

    public void setNeedToReturnAcceptedQuantity(Integer needToReturnAcceptedQuantity) {
        this.needToReturnAcceptedQuantity = needToReturnAcceptedQuantity;
    }

    public Integer getNeedToReturnDamageQuantity() {
        return needToReturnDamageQuantity;
    }

    public void setNeedToReturnDamageQuantity(Integer needToReturnDamageQuantity) {
        this.needToReturnDamageQuantity = needToReturnDamageQuantity;
    }

    public Long getSpvId() {
        return spvId;
    }

    public void setSpvId(Long spvId) {
        this.spvId = spvId;
    }

    public String getComId() {
        return comId;
    }

    public void setComId(String comId) {
        this.comId = comId;
    }

    public Integer getAlreadySendQuantity() {
        return alreadySendQuantity;
    }

    public void setAlreadySendQuantity(Integer alreadySendQuantity) {
        this.alreadySendQuantity = alreadySendQuantity;
    }

    public Integer getAlreadyReturnQuantity() {
        return alreadyReturnQuantity;
    }

    public void setAlreadyReturnQuantity(Integer alreadyReturnQuantity) {
        this.alreadyReturnQuantity = alreadyReturnQuantity;
    }

    public BigDecimal getUnitRefundAmount() {
        return unitRefundAmount;
    }

    public void setUnitRefundAmount(BigDecimal unitRefundAmount) {
        this.unitRefundAmount = unitRefundAmount;
    }

    public List<SoExchangeSkuVO> getExchangeSkuList() {
        return exchangeSkuList;
    }

    public void setExchangeSkuList(List<SoExchangeSkuVO> exchangeSkuList) {
        this.exchangeSkuList = exchangeSkuList;
    }

    public String getSelExchangeSkuCode() {
        return selExchangeSkuCode;
    }

    public void setSelExchangeSkuCode(String selExchangeSkuCode) {
        this.selExchangeSkuCode = selExchangeSkuCode;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public Integer getSelExchangeSkuIsJit() {
        return selExchangeSkuIsJit;
    }

    public void setSelExchangeSkuIsJit(Integer selExchangeSkuIsJit) {
        this.selExchangeSkuIsJit = selExchangeSkuIsJit;
    }

	public BigDecimal getAptUGiftCardAmount() {
		return aptUGiftCardAmount;
	}

	public void setAptUGiftCardAmount(BigDecimal aptUGiftCardAmount) {
		this.aptUGiftCardAmount = aptUGiftCardAmount;
	}
}
