package com.thebeastshop.salesorder.service;

import com.thebeastshop.salesorder.vo.pub.SoIposOrderVO;

import java.util.Date;
import java.util.List;

/**
 * @ClassName: SoCateringOrderService
 * @Description: 餐饮订单服务
 * @Author xiang.gao
 * @Date 2024/9/3 17:08
 */
public interface SoCateringOrderService {

    /**
     * 未支付订单挂起
     * @param orderCode
     * @return
     */
    boolean unpaidOrderHold(String orderCode);

    /**
     * 待支付挂起订单数量
     * @param channelCode
     * @param limitTime
     * @return
     */
    int countUnpaidHoldOrder(String channelCode, Date limitTime);

    /**
     * 待支付挂起订单
     * @param channelCode
     * @param limitTime
     * @return
     */
    List<SoIposOrderVO> getUnpaidHoldOrderList(String channelCode, Date limitTime);

}
