package com.thebeastshop.salesorder.vo.simple;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.salesorder.dto.SoThirdChannelCPSDto;
import com.thebeastshop.salesorder.vo.SoWhAllotRcdVO;
import com.thebeastshop.salesorder.vo.pub.SoPsIdCardVO;
import com.thebeastshop.salesorder.vo.pub.SoPsInvoiceInfoVO;
import com.thebeastshop.salesorder.vo.pub.SoPsPackageSkuVO;
import com.thebeastshop.salesorder.vo.pub.SoPsPackageVO;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.math.BigDecimal;
import java.util.*;

/***
 * 简单订单VO
 *
 * @author zq.chen
 */
public class SoPsSimpleOrderVO extends BaseDO {

    //订单ID
    private Long id;
    //订单编码
    private String code;
    //下单渠道
    private String channelCode;
    //会员编码
    private String memberCode;
    //订单类型
    private Integer orderType = 0;
    //海淘标记 0普通 １海淘
    private Integer crossBorderFlag;
    //订单状态
    private Integer salesOrderStatus;
    //预计发货日期
    private Date planedDeliveryDate;
    //支付方式，1现金 2借记卡 3信用卡 4微信 5支付宝 6招行
    private Integer paymentType;
    //支付时间
    private Date payTime;
    //创建时间
    private Date createTime;
    //订单对应的skuCodes列表
    private List<String> skuCodes = new ArrayList<>();
    //订单对应的productCode列表
    private List<String> productCodes = new ArrayList<>();


    /************************ 金额相关 ************************/
    //总额：订单所有商品折后价+优惠+各种费用（商品折后价+优惠=商品原价）
    //应付：去掉折扣和优惠后，用户要付出的钱，无论什么形式（包含现金、支付宝、礼品卡、储值等）
    //实付：用户现场实际付出的钱（不包含礼品卡、储值等预存性质的钱）

    //订单总金额（所有钱）
    private BigDecimal totalAmount = BigDecimal.ZERO;
    //剩余实付总金额（多次支付时的概念，不包括礼品卡、储值）
    private BigDecimal needToPayAmount = BigDecimal.ZERO;
    //应付总金额（实付剩余总金额+礼品卡+储值+基金）
    private BigDecimal totalNeedToPayAmount = BigDecimal.ZERO;
    //折后总金额，sum(行总价-行总折扣)
    private BigDecimal totalAmountAfterDiscount = BigDecimal.ZERO;
    //礼品卡支付金额
    //private BigDecimal giftCardAmount = BigDecimal.ZERO;
    //预存款支付金额
    //private BigDecimal accountPayAmount = BigDecimal.ZERO;
    //运费
    //private BigDecimal carriageAmount = BigDecimal.ZERO;
    //订单头折扣
    //private BigDecimal discountOnHead = BigDecimal.ZERO;
    //订单行折扣汇总
    //private BigDecimal discountOnLine = BigDecimal.ZERO;
    //生日折扣
    //private BigDecimal birthdayDiscountAmount = BigDecimal.ZERO;
    //定制费
    //private BigDecimal customizationAmount = BigDecimal.ZERO;
    //定制折扣
    //private BigDecimal customizationDiscount = BigDecimal.ZERO;
    //基金返还金额
    //private BigDecimal fundReturnAmount = BigDecimal.ZERO;
    //基金支付金额（跟积分抵扣性质类似）
    //private BigDecimal fundPayAmount = BigDecimal.ZERO;
    //生日优惠折扣
    //private BigDecimal birthdayDiscount = BigDecimal.ZERO;
    //海淘运输费用
    //private BigDecimal crossFee = BigDecimal.ZERO;
    //服务费
    //private BigDecimal serviceFeeAmount = BigDecimal.ZERO;
    //头积分
    //private BigDecimal pointOnLine = BigDecimal.ZERO;
    //头积分抵扣金额
    //private BigDecimal pointOnHeadDeduction = BigDecimal.ZERO;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public Integer getSalesOrderStatus() {
        return salesOrderStatus;
    }

    public void setSalesOrderStatus(Integer salesOrderStatus) {
        this.salesOrderStatus = salesOrderStatus;
    }

    public Date getPlanedDeliveryDate() {
        return planedDeliveryDate;
    }

    public void setPlanedDeliveryDate(Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public Integer getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(List<String> skuCodes) {
        this.skuCodes = skuCodes;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getNeedToPayAmount() {
        return needToPayAmount;
    }

    public void setNeedToPayAmount(BigDecimal needToPayAmount) {
        this.needToPayAmount = needToPayAmount;
    }

    public BigDecimal getTotalNeedToPayAmount() {
        return totalNeedToPayAmount;
    }

    public void setTotalNeedToPayAmount(BigDecimal totalNeedToPayAmount) {
        this.totalNeedToPayAmount = totalNeedToPayAmount;
    }

    public BigDecimal getTotalAmountAfterDiscount() {
        return totalAmountAfterDiscount;
    }

    public void setTotalAmountAfterDiscount(BigDecimal totalAmountAfterDiscount) {
        this.totalAmountAfterDiscount = totalAmountAfterDiscount;
    }

    public List<String> getProductCodes() {
        return productCodes;
    }

    public void setProductCodes(List<String> productCodes) {
        this.productCodes = productCodes;
    }

    @Override
    public String toString() {
        return "SoPsSimpleOrderVO{" +
                "id=" + id +
                ", code='" + code + '\'' +
                ", channelCode='" + channelCode + '\'' +
                ", memberCode='" + memberCode + '\'' +
                ", orderType=" + orderType +
                ", crossBorderFlag=" + crossBorderFlag +
                ", salesOrderStatus=" + salesOrderStatus +
                ", planedDeliveryDate=" + planedDeliveryDate +
                ", paymentType=" + paymentType +
                ", payTime=" + payTime +
                ", createTime=" + createTime +
                ", skuCodes=" + skuCodes +
                ", productCodes=" + productCodes +
                ", totalAmount=" + totalAmount +
                ", needToPayAmount=" + needToPayAmount +
                ", totalNeedToPayAmount=" + totalNeedToPayAmount +
                ", totalAmountAfterDiscount=" + totalAmountAfterDiscount +
                '}';
    }
}
