package com.thebeastshop.salesorder.service;

import java.util.List;

import com.thebeastshop.salesorder.vo.SoIdentityPictureVO;
import com.thebeastshop.salesorder.vo.SoIdentityVO;

/**
 * 订单身份证
 * @Class Name SoIdentityService
 * @Author Xiang.Gao
 * @Create In 2018-10-16
 */
public interface SoIdentityService {
	
	/**
     * 修改订单身份证图片和身份证图片状态
     * @param uploadPictureParam
     * @return
     */
    public Boolean updateSalesOrderIdentityAuditStatus(SoIdentityPictureVO uploadPictureParam);

    /**
     * 通过订单编号
     * @param orderCode
     * @return
     */
    public SoIdentityVO getOpSaleOrderIdenByOrderNo(String orderCode);
    
    /**
     * 通过订单ID
     * @param orderId
     * @return
     */
    public SoIdentityVO getOpSaleOrderIdenByOrderId(Long orderId);

    /**
     * 查询身份证记录
     * @param memberCode
     * @param name
     * @param idNumber
     * @return
     */
    public List<SoIdentityVO> selectIdentityByMemberCodeAndIdNumber(String memberCode,String name,String idNumber);
	
}
