package com.thebeastshop.salesorder.enums;

import com.thebeastshop.common.utils.EnumUtil;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-23 18:04
 */
public enum SoPackageDeliveryTypeEnum {

    EXPRESS(1, "快递"),

    NOT_EXPRESS(0, "非快递")

    ;

    private Integer id;

    private String name;

    SoPackageDeliveryTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static SoPackageDeliveryTypeEnum getEnumById(Integer id) {
        for (SoPackageDeliveryTypeEnum e : SoPackageDeliveryTypeEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }

    public String getNameById(Integer id) {
        return EnumUtil.getNameById(id, SoPackageDeliveryTypeEnum.class);
    }

}
