package com.thebeastshop.salesorder.dto;

import java.io.Serializable;
import java.util.Date;

import com.thebeastshop.common.BaseDO;

/**
 * create by com.thebeastshop.pegasus.service.operation.cond parent :author lijing
 * User:lijing
 * DATE : 2016/6/16
 * TIME : 14:45
 * parent.
 */
public class SoOrderIdCardCond extends BaseDO {
    private static final long serialVersionUID = 1L;
	private static final String ORDER_BY_CLAUSE_LABEL = "toso.CREATE_TIME";
    /**
     *  审核状态   1未审核  2 审核通过  3审核不通过     */
    private Integer status;

    private Date createAt;

    private Date createEnd;

    /**姓名*/
    private String name;
    /**身份证号*/
    private String idNumber;
    /**订单号*/
    private String orderNo;

    /**
     * 当前页从1开始
     */
    private Integer currentPage;

    /**
     * 每页数量
     */
    private Integer pageSize;

    /**当前页码*/
    private Integer offset;
    /**
     * 排序方式
     */
    private String orderByClause = ORDER_BY_CLAUSE_LABEL;

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

    public Date getCreateEnd() {
        return createEnd;
    }

    public void setCreateEnd(Date createEnd) {
        this.createEnd = createEnd;
    }

    public Integer getOffset() {
        if (currentPage == null || currentPage < 1 || pageSize == null || pageSize < 1) {
            return 0;
        }
        return  (currentPage -1) * pageSize;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdNumber() {
        return idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }
}
