/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.vo.inner;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.salesorder.enums.SoInvoiceInfoStatusEnum;
import com.thebeastshop.salesorder.enums.SoInvoiceInfoTypeEnum;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Eric.Lou
 * @version $Id: OpSoInvoiceInfoVO.java, v 0.1 2015-08-17 12:03
 */
public class SoInInvoiceInfoVO extends BaseDO {

    private static final long serialVersionUID = 1L;


	// constructor
    public SoInInvoiceInfoVO() {

    }

    // original
    private Long id;

    private Long salesOrderId;

    private Integer invoiceType;

    private String invoiceTitle;

    private BigDecimal invoiceAmount;

    private Long districtId;

    private String address;

    private String zipCode;

    private String receiver;

    private String receiverPhone;

    private Integer invoiceStatus;

    private Date applyTime;

    private long applyOperatorId;

    private String applyOperatorName;

    private Date makeTime;

    private Integer isEmergency;

    private BigDecimal refundAmount;

    private BigDecimal actualAmount;

    private String innerRemark;

    private String financeRemark;

    private Date deliveryTime;

    private String deliveryCode;


    // self
    private String districtName;

    private String salesOrderCode;

    private String salesOrderChannelName;
    
    
    private String invoiceNumber;
    

    public String getInvoiceStatusName() {
        if (invoiceStatus == null) return "";
        SoInvoiceInfoStatusEnum invoiceInfoStatusEnum = SoInvoiceInfoStatusEnum.getEnumById(invoiceStatus);
        if (invoiceInfoStatusEnum == null) return "";
        return invoiceInfoStatusEnum.getName();
    }

    public String getInvoiceTypeName(){
        if (invoiceType == null) return "";
        SoInvoiceInfoTypeEnum invoiceInfoTypeEnum = SoInvoiceInfoTypeEnum.getEnumById(invoiceType);
        if (invoiceInfoTypeEnum == null) return "";
        return invoiceInfoTypeEnum.getName();
    }

    
    public String getSalesOrderChannelName() {
		return salesOrderChannelName;
	}

	public void setSalesOrderChannelName(String salesOrderChannelName) {
		this.salesOrderChannelName = salesOrderChannelName;
	}

	// auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSalesOrderId() {
        return salesOrderId;
    }

    public void setSalesOrderId(Long salesOrderId) {
        this.salesOrderId = salesOrderId;
    }

    public Integer getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Integer invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public BigDecimal getInvoiceAmount() {
        return invoiceAmount;
    }

    public void setInvoiceAmount(BigDecimal invoiceAmount) {
        this.invoiceAmount = invoiceAmount;
    }

    public Long getDistrictId() {
        return districtId;
    }

    public void setDistrictId(Long districtId) {
        this.districtId = districtId;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getReceiver() {
        return receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public String getReceiverPhone() {
        return receiverPhone;
    }

    public void setReceiverPhone(String receiverPhone) {
        this.receiverPhone = receiverPhone;
    }

    public Integer getInvoiceStatus() {
        return invoiceStatus;
    }

    public void setInvoiceStatus(Integer invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public long getApplyOperatorId() {
        return applyOperatorId;
    }

    public void setApplyOperatorId(long applyOperatorId) {
        this.applyOperatorId = applyOperatorId;
    }

    public String getApplyOperatorName() {
        return applyOperatorName;
    }

    public void setApplyOperatorName(String applyOperatorName) {
        this.applyOperatorName = applyOperatorName;
    }

    public Date getMakeTime() {
        return makeTime;
    }

    public void setMakeTime(Date makeTime) {
        this.makeTime = makeTime;
    }

    public Integer getIsEmergency() {
        return isEmergency;
    }

    public void setIsEmergency(Integer isEmergency) {
        this.isEmergency = isEmergency;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public BigDecimal getActualAmount() {
        return actualAmount;
    }

    public void setActualAmount(BigDecimal actualAmount) {
        this.actualAmount = actualAmount;
    }

    public String getInnerRemark() {
        return innerRemark;
    }

    public void setInnerRemark(String innerRemark) {
        this.innerRemark = innerRemark;
    }

    public String getFinanceRemark() {
        return financeRemark;
    }

    public void setFinanceRemark(String financeRemark) {
        this.financeRemark = financeRemark;
    }

    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public String getDeliveryCode() {
        return deliveryCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getSalesOrderCode() {
        return salesOrderCode;
    }

    public void setSalesOrderCode(String salesOrderCode) {
        this.salesOrderCode = salesOrderCode;
    }

	public String getInvoiceNumber() {
		return invoiceNumber;
	}

	public void setInvoiceNumber(String invoiceNumber) {
		this.invoiceNumber = invoiceNumber;
	}
    
    
    
}
