package com.thebeastshop.salesorder.enums;


import com.thebeastshop.common.utils.EnumUtil;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-23 15:24
 */
public enum SoOrderTypeEnum {

    SALES(1, "渠道销售单"),

    EXCHANGE(2, "渠道换货单"),

    GROUP(3, "集团订单"),

    REPLENISH(4, "渠道补货单"),

    GIFT(11, "领用单"),

    SAMPLE(12, "样品订单"),

    THIRD(13, "第三方订单"),

    ;

    private Integer id;

    private String name;

    SoOrderTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static SoOrderTypeEnum getEnumById(Integer id) {
        for (SoOrderTypeEnum e : SoOrderTypeEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }


    public String getNameById(Integer id) {
        return EnumUtil.getNameById(id, SoOrderTypeEnum.class);
    }

}
