package com.thebeastshop.privilege.vo;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaodong.cheng on 2019/8/21.
 */
public class InterestResponse implements Serializable{

    private static final long serialVersionUID = 1L;
    private String appId;
    private String respCode;
    private String respMsg;
    private Map<String, Object> errorData;
    private boolean isSuccess = true;
    private Object bean;

    public static InterestResponse newInstanceSuccess() {
        return newInstanceSuccess(null);
    }

    public static InterestResponse newInstanceSuccess(Object bean) {
        InterestResponse response = new InterestResponse();
        response.setRespCode("200");
        response.setBean(bean);
        return response;
    }

    public static InterestResponse newInstanceFail(String msg) {
        return newInstanceFail("500", msg);
    }

    public static InterestResponse newInstanceFail(String code, String msg) {
        return newInstanceFail(code, msg, new HashMap());
    }

    public static InterestResponse newInstanceFail(String code, String msg, Map<String, Object> errorData) {
        InterestResponse response = new InterestResponse();
        response.setRespCode(code);
        response.setRespMsg(msg);
        response.setErrorData(errorData);
        response.setSuccess(false);
        return response;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getRespCode() {
        return respCode;
    }

    public void setRespCode(String respCode) {
        this.respCode = respCode;
    }

    public String getRespMsg() {
        return respMsg;
    }

    public void setRespMsg(String respMsg) {
        this.respMsg = respMsg;
    }

    public Map<String, Object> getErrorData() {
        return errorData;
    }

    public void setErrorData(Map<String, Object> errorData) {
        this.errorData = errorData;
    }

    public boolean isSuccess() {
        return isSuccess;
    }

    public void setSuccess(boolean success) {
        isSuccess = success;
    }

    public Object getBean() {
        return bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }
}
