package com.thebeastshop.privilege.enumeration;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2017/4/17
 */
public enum PrivilegCodeExchangeTypeEnum implements Serializable{
    DISCOUNT(1, "合作会员折扣"),
    GOODS_PRIVILEGE(2, "商品权益"),
    FREE_PRIVILEGE(3, "免邮权益"),
    COUPON(4, "优惠券");

    private Integer id;
    private String name;
    public static final List<PrivilegCodeExchangeTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(PrivilegCodeExchangeTypeEnum.values()));

    PrivilegCodeExchangeTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static PrivilegCodeExchangeTypeEnum getEnumById(Integer id) {
        PrivilegCodeExchangeTypeEnum[] values = PrivilegCodeExchangeTypeEnum.values();
        for (PrivilegCodeExchangeTypeEnum item : values) {
            if (item.getId().equals(id)) {
                return item;
            }
        }
        return null;
    }
}
