package com.thebeastshop.privilege.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.privilege.cond.FlowerPackageCond;
import com.thebeastshop.privilege.vo.FlowerPackageCarVO;
import com.thebeastshop.privilege.vo.FlowerPackageVO;

import java.util.List;

public interface FlowerPackageService {
    ServiceResp<PageQueryResp<FlowerPackageVO>> findCond(FlowerPackageCond cond);
    ServiceResp<List<FlowerPackageVO>> findListByCond(FlowerPackageCond cond);
    ServiceResp<FlowerPackageVO> findByPackageId(Long packageId);
    ServiceResp<FlowerPackageCarVO> findByCarId(Integer carId);

    ServiceResp<List<FlowerPackageCarVO>> findByPackageIds(List<Long> packageIds);

    ServiceResp<List<FlowerPackageVO>> findPackageIdByPackageCodes(List<String> packageCodes);

    ServiceResp<List<FlowerPackageCarVO>> findByPackageByCar(FlowerPackageCond cond);

    ServiceResp<FlowerPackageCarVO> findByPackageByCar(Integer carId);

    ServiceResp importCarNumber(List<FlowerPackageCarVO> cars);

    ServiceResp deletePackageIdByCar(Long packageId,Integer carId);

    ServiceResp modifyDriverInfo(FlowerPackageCarVO carVO);




}
