package com.thebeastshop.privilege.enumeration;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2017/4/17
 * 特权类型(1.等级礼包, 2:生日礼包 3:VIP折扣 4:免邮福利 5:求签福利 6:活动福利)
 */
public enum PrivilegTypeEnum implements Serializable{
    GRADE_GIFT_BAG(1, "等级礼包"),
    BD_GIFT_BAG(2, "生日礼包"),
    VIP_DISCOUNT(3, "VIP折扣"),
    FREE_POSTAGE_WELFARE(4, "免邮福利"),
    KAU_CIM_WELFARE(5, "求签福利"),
    ACTIVITY_WELFARE(6, "活动福利"),
    ACTIVITY_INVITE(7, "活动邀请"),

    FREE_CUSTOMIZED_FEE(8, "免定制费"),
    BIRTHDAY_GIFT(11, "生日到店礼"),
    BIRTHDAY_DISCOUNT(12, "生日折扣"),

    REDEEM_POINTS(13, "积分兑换"),
    ;

    private Integer id;
    private String name;
    public static final List<PrivilegTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(PrivilegTypeEnum.values()));

    PrivilegTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static PrivilegTypeEnum getEnumById(Integer id) {
        PrivilegTypeEnum[] values = PrivilegTypeEnum.values();
        for (PrivilegTypeEnum item : values) {
            if (item.getId().equals(id)) {
                return item;
            }
        }
        return null;
    }
}
