package com.thebeastshop.privilege.enumeration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 课程状态枚举
 * @author LK
 *
 */
public enum BirthdayGiftActivateStatusEnum {
	ACTIVED(1, "已激活"),
	NOACTIVED(2, "未激活"),
	;

	public final Integer status;
	public final String desc;

	public static final List<BirthdayGiftActivateStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private BirthdayGiftActivateStatusEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	 // 普通方法
    public static String getDesc(int status) {

        for (BirthdayGiftActivateStatusEnum c : ALL) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

}
