package com.thebeastshop.privilege.service;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.privilege.cond.FrontBirthdayGiftVerifyCond;
import com.thebeastshop.privilege.dto.FrontBirthdayGiftVerifyDTO;
import com.thebeastshop.privilege.vo.FrontBirthdayGiftVO;
import com.thebeastshop.privilege.vo.FrontIosBirthdayGiftStatusVO;

import java.util.Date;
import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2017/4/17 19:41
 */
public interface FrontBirthdayGiftService {
    /**
     * 查询松鼠会员是否激活
     * @param memberCode
     * @return
     */
    ServiceResp<Boolean> queryActivateStatus(String memberCode,Date birthday,Integer memberLevel);

    /**
     * 查询IPOS会员状态
     * @param cond
     * @return
     */
    ServiceResp<FrontIosBirthdayGiftStatusVO> queryIposMemberCodeStatus(FrontBirthdayGiftVerifyCond cond);
    /**
     * 核销生日到店礼
     * @param dto
     * @return
     */
    ServiceResp<Boolean> verify(FrontBirthdayGiftVerifyDTO dto);

    /**
     * 松鼠会员激活生日到店礼
     * @param memberCode
     * @return
     */
    ServiceResp<Boolean> activate(String memberCode);

    /**
     * 整单取消or退货激返还生日到店礼
     * @param cond
     * @return
     */
    ServiceResp<Boolean> returnBirthDayGift(FrontBirthdayGiftVerifyCond cond);

    /**
     * 查询APP生日到店礼
     * @param memberCode
     * @return
     */
    ServiceResp<List<FrontBirthdayGiftVO>> queryAppBirthDayGiftList(String memberCode,Integer merLevel,Date birthday);

    /**
     * 查询APP生日到店礼
     * @param memberCode
     * @return
     */
    ServiceResp<List<FrontBirthdayGiftVO>> queryAppBirthDayGiftListNoBirthday(String memberCode,Integer merLevel);

    /**
     * 查询SCM生日到店礼
     * @param memberCode
     * @return
     */
    ServiceResp<List<FrontBirthdayGiftVO>> queryScmBirthDayGiftList(String memberCode);

    ServiceResp<List<FrontBirthdayGiftVO>> queryMessageBirthDayGiftList(String memberCode);


    /**
     * 查询IPOS生日到店礼可用商品CODE
     * @param cond
     * @return
     */
    ServiceResp<List<String>> queryIposBirthDayGiftProdCodeList(FrontBirthdayGiftVerifyCond cond);

    /**
     * 查询适用门店通过ID
     * @param giftId
     * @return
     */
    ServiceResp<List<String>> queryBirthdaySupportOfflineChannelCodeByGiftId(Integer giftId);

}
