package com.thebeastshop.privilege.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.privilege.cond.BrandGiftCond;
import com.thebeastshop.privilege.cond.BrandGiftRecordCond;
import com.thebeastshop.privilege.vo.BrandGiftOrgVO;
import com.thebeastshop.privilege.vo.BrandGiftRecordVO;
import com.thebeastshop.privilege.vo.BrandGiftVO;
import com.thebeastshop.privilege.vo.ValueLabelVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * Created by gensheng.ye on 2022/3/31.
 */
public interface BrandGiftService {
    ServiceResp<BrandGiftVO> findById(Integer id);
    ServiceResp<Integer> deleteById(Integer id);
    ServiceResp<Integer> create(BrandGiftVO vo);
    ServiceResp update(BrandGiftVO vo);
    ServiceResp<PageQueryResp<BrandGiftVO>> listActivity(BrandGiftCond cond);
    ServiceResp<PageQueryResp<BrandGiftRecordVO>> recordList(BrandGiftRecordCond cond);
    ServiceResp<List<BrandGiftRecordVO>> recordListExport(BrandGiftRecordCond cond);
    List<ValueLabelVO> findGiftCreateDropList(Integer activityId);
    List<ValueLabelVO> findGiftOrgDropList(Integer activityId);

    ServiceResp<BrandGiftRecordVO> findRecordById(Integer id);
    ServiceResp<Integer> updateRecord(BrandGiftRecordVO vo);
    ServiceResp<Integer>  updateRecordNotValid(BrandGiftRecordVO vo);
    ServiceResp updateSmallProgramCode(List<BrandGiftOrgVO> orgVOList);
    ServiceResp deleteOrg(List<Integer> ids);
}



