package com.thebeastshop.privilege.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.privilege.cond.AccelerateUpgradeTaskCond;
import com.thebeastshop.privilege.cond.FrontAccelerateUpgradeTaskCond;
import com.thebeastshop.privilege.vo.AccelerateUpgradeTaskMemberVO;
import com.thebeastshop.privilege.vo.AccelerateUpgradeTaskVO;
import com.thebeastshop.privilege.vo.FrontAccelerateUpgradeTaskVO;

import java.util.List;

/**
 * Created by gensheng.ye on 2020/9/17.
 */
public interface FrontAccelerateUpgradeTaskService {
    //进行中或者已结束的活动
    ServiceResp<FrontAccelerateUpgradeTaskVO> findByCond(FrontAccelerateUpgradeTaskCond cond);
    //加入活动
    ServiceResp<Boolean> join(String memberCode);
    //进行中的活动（升级时间）
    ServiceResp<FrontAccelerateUpgradeTaskVO> findByMemberCode(String memberCode);
    //合并会员
    ServiceResp<Boolean> mergeAccelerateUpgradeTask(Long mainMemberId, Long subMemberId);
    //IPOS已参与用户
    ServiceResp<List<AccelerateUpgradeTaskMemberVO>> findJoinMemberByTastCode(String upgradeTaskCode);
    //升级结束后的活动
    ServiceResp<FrontAccelerateUpgradeTaskVO> findUpgradeEndByMemberCode(String memberCode);
    //所有活动
    ServiceResp<List<FrontAccelerateUpgradeTaskVO>> findAllByMemberCode(String memberCode);
    //进行中的活动（统计时间）
    ServiceResp<FrontAccelerateUpgradeTaskVO> findContinueByMemberCode(String memberCode);
}
