/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pcs.enums;

import com.thebeastshop.common.utils.EmptyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PoContractCompanyEnum {
    BEAST((short)1, "Shanghai Yepai E-commerce Co.,Ltd.", "\u4e0a\u6d77\u91ce\u6d3e\u7535\u5b50\u5546\u52a1\u6709\u9650\u516c\u53f8"),
    BUTUT((short)2, "BUTO Cosmetics(Shanghai)Co.,Ltd", "\u5e03\u56fe\u65e5\u5316\uff08\u4e0a\u6d77\uff09\u6709\u9650\u516c\u53f8"),
    BEAST_HK((short)3, "Thebeastshop HK Limited", "Thebeastshop HK Limited"),
    BLUE_LOVE((short)5, "Shanghai BLEUBLEUET E-commerce Co.,Ltd", "\u4e0a\u6d77\u5e03\u9c81\u7231\u7535\u5b50\u5546\u52a1\u6709\u9650\u516c\u53f8"),
    LOVE_BLUE((short)6, "Shanghai BLEUBLEUET E-commerce Co.,Ltd", "\u4e0a\u6d77\u827e\u5e03\u9c81\u4fe1\u606f\u79d1\u6280\u6709\u9650\u516c\u53f8"),
    BUYE_DAILY_CHEMICAL((short)7, "Shanghai BUYE Cosmetics Co.,Ltd", "\u4e0a\u6d77\u5e03\u91ce\u65e5\u5316\u6709\u9650\u516c\u53f8"),
    PUFF((short)8, "Shanghai Pupai E-commerce Co.,Ltd.", "\u4e0a\u6d77\u5657\u6d3e\u7535\u5b50\u5546\u52a1\u6709\u9650\u516c\u53f8");

    public final Short code;
    public final String englishName;
    public final String chineseName;
    public static final List<PoContractCompanyEnum> ALL;

    private PoContractCompanyEnum(Short code, String englishName, String chineseName) {
        this.code = code;
        this.englishName = englishName;
        this.chineseName = chineseName;
    }

    public static final Short getCodeByChineseName(String companyDesc) {
        Short statusVal = null;
        for (PoContractCompanyEnum companyAttrEnum : PoContractCompanyEnum.values()) {
            if (!companyAttrEnum.chineseName.equals(companyDesc)) continue;
            statusVal = companyAttrEnum.code;
            break;
        }
        return statusVal;
    }

    public static final List<Map<String, Object>> listMapEnum() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (PoContractCompanyEnum skuCompanyAttrEnum : ALL) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("value", skuCompanyAttrEnum.code);
            map.put("name", skuCompanyAttrEnum.chineseName);
            list.add(map);
        }
        return list;
    }

    public static PoContractCompanyEnum getEnumByCode(Short code) {
        if (EmptyUtil.isEmpty((Object)code)) {
            return null;
        }
        for (PoContractCompanyEnum c : ALL) {
            if (c.getCode() != code) continue;
            return c;
        }
        return null;
    }

    public Short getCode() {
        return this.code;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public String getChineseName() {
        return this.chineseName;
    }

    static {
        ALL = Collections.unmodifiableList(Arrays.asList(PoContractCompanyEnum.values()));
    }
}

