/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pcs.vo;

import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.pcs.vo.PcsSkuAutoApproveBgmVO;
import com.thebeastshop.pcs.vo.PcsSkuFinanceAutoApproveRule;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PcsSkuFinanceAutoApproveRuleVO
extends PcsSkuFinanceAutoApproveRule {
    public static final String ENTITY_ID_LOG = "FINANCE_AUTO_APPROVE_RULE";
    public static final String ENTITY_CLASS_LOG = "PcsSkuFinanceAutoApproveRuleVO";
    public static final Integer AUTO_APPROVE_TYPE_RAW_MATERIAL = 1;
    public static final Integer AUTO_APPROVE_TYPE_SEMIFINISHED_PRODUCT = 2;
    public static final String AUTO_APPROVE_TYPE_RAW_MATERIAL_STR = "\u539f\u6750\u6599";
    public static final String AUTO_APPROVE_TYPE_SEMIFINISHED_PRODUCT_STR = "\u534a\u6210\u54c1";
    public static final Map<Integer, String> AUTO_APPROVE_TYPE_MAP = new HashMap<Integer, String>(){
        {
            this.put(AUTO_APPROVE_TYPE_RAW_MATERIAL, PcsSkuFinanceAutoApproveRuleVO.AUTO_APPROVE_TYPE_RAW_MATERIAL_STR);
            this.put(AUTO_APPROVE_TYPE_SEMIFINISHED_PRODUCT, PcsSkuFinanceAutoApproveRuleVO.AUTO_APPROVE_TYPE_SEMIFINISHED_PRODUCT_STR);
        }
    };
    public static final Integer ZERO_COST_AUTO_APPROVE_GENERAL_GOODS = 1;
    public static final Integer ZERO_COST_AUTO_APPROVE_GIFT = 2;
    public static final Integer ZERO_COST_AUTO_APPROVE_SAMPLE_SACK = 3;
    public static final Integer ZERO_COST_AUTO_APPROVE_DISPLAY = 4;
    public static final String ZERO_COST_AUTO_APPROVE_GENERAL_GOODS_STR = "\u666e\u901a\u5546\u54c1";
    public static final String ZERO_COST_AUTO_APPROVE_GIFT_STR = "\u8d60\u54c1";
    public static final String ZERO_COST_AUTO_APPROVE_SAMPLE_SACK_STR = "\u8bd5\u7528\u88c5";
    public static final String ZERO_COST_AUTO_APPROVE_DISPLAY_STR = "\u9648\u5217\u54c1";
    public static final Map<Integer, String> ZERO_COST_AUTO_APPROVE_MAP = new HashMap<Integer, String>(){
        {
            this.put(ZERO_COST_AUTO_APPROVE_GENERAL_GOODS, PcsSkuFinanceAutoApproveRuleVO.ZERO_COST_AUTO_APPROVE_GENERAL_GOODS_STR);
            this.put(ZERO_COST_AUTO_APPROVE_GIFT, PcsSkuFinanceAutoApproveRuleVO.ZERO_COST_AUTO_APPROVE_GIFT_STR);
            this.put(ZERO_COST_AUTO_APPROVE_SAMPLE_SACK, PcsSkuFinanceAutoApproveRuleVO.ZERO_COST_AUTO_APPROVE_SAMPLE_SACK_STR);
            this.put(ZERO_COST_AUTO_APPROVE_DISPLAY, PcsSkuFinanceAutoApproveRuleVO.ZERO_COST_AUTO_APPROVE_DISPLAY_STR);
        }
    };
    public static final Integer SALE_PROXY = 1;
    public static final Integer SALE_NO_IMPORTED = 2;
    public static final Integer SALE_IMPORTED_CROSS_BORDER = 3;
    public static final Integer SALE_IMPORTED_NO_CROSS_BORDER = 4;
    public static final String SALE_PROXY_STR = "\u4ee3\u9500";
    public static final String SALE_NO_IMPORTED_STR = "\u7ecf\u9500\u975e\u8fdb\u53e3";
    public static final String SALE_IMPORTED_CROSS_BORDER_STR = "\u7ecf\u9500\u8fdb\u53e3\u8de8\u5883";
    public static final String SALE_IMPORTED_NO_CROSS_BORDER_STR = "\u7ecf\u9500\u8fdb\u53e3\u975e\u8de8\u5883";
    public static final Integer SKU_COST_RISE_UNDER = 1;
    public static final Integer MATERIAL_COST_RISE_UNDER = 2;
    private Long id;
    private List<String> categoryNames;
    private String autoApproveTypesStr;
    private String zeroCostAutoApprovesStr;
    private List<PcsSkuAutoApproveBgmVO> skuAutoApproveBgms;
    private List<PcsSkuAutoApproveBgmVO> skuAutoApproveBgmVOs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<String> getCategoryNames() {
        return this.categoryNames;
    }

    public void setCategoryNames(List<String> categoryNames) {
        this.categoryNames = categoryNames;
    }

    public String toString() {
        return "PcsSkuFinanceAutoApproveRuleVO{categoryName=" + this.categoryNames + '}';
    }

    public String toCustomString() {
        return "\u66f4\u65b0{\u81ea\u52a8\u5ba1\u6279\u54c1\u7c7b=" + this.categoryNames + ", \u81ea\u52a8\u5ba1\u6279\u7c7b\u578b=" + this.getAutoApproveTypesStr() + " 0\u6210\u672c\u81ea\u52a8\u5ba1\u6279=" + this.getZeroCostAutoApprovesStr() + " \u6210\u672c\u4e0a\u6d6e\u4f4e\u4e8e=" + this.getCostRiseUnderPercent() + ", \u8017\u6750\u6210\u672c\u4e0a\u6d6e\u4f4e\u4e8e=" + this.getMaterialCostRiseUnderPercent() + "}";
    }

    public String getCostRiseUnderPercent() {
        if (EmptyUtil.isNotEmpty((String)this.getCostRiseUnder())) {
            return new BigDecimal(this.getCostRiseUnder()).multiply(new BigDecimal(100)).setScale(0) + "%";
        }
        return "";
    }

    public String getMaterialCostRiseUnderPercent() {
        if (EmptyUtil.isNotEmpty((String)this.getMaterialCostRiseUnder())) {
            return new BigDecimal(this.getMaterialCostRiseUnder()).multiply(new BigDecimal(100)).setScale(0) + "%";
        }
        return "";
    }

    public String getAutoApproveTypesStr() {
        if (EmptyUtil.isEmpty((String)this.autoApproveTypesStr) && EmptyUtil.isNotEmpty(this.getAutoApproveTypes())) {
            this.autoApproveTypesStr = "";
            if (this.getAutoApproveTypes().contains(AUTO_APPROVE_TYPE_RAW_MATERIAL)) {
                this.autoApproveTypesStr = this.autoApproveTypesStr + "\u539f\u6750\u6599,";
            }
            if (this.getAutoApproveTypes().contains(AUTO_APPROVE_TYPE_SEMIFINISHED_PRODUCT)) {
                this.autoApproveTypesStr = this.autoApproveTypesStr + "\u534a\u6210\u54c1,";
            }
        }
        if (this.autoApproveTypesStr == null) {
            this.autoApproveTypesStr = "";
        }
        return this.autoApproveTypesStr;
    }

    public void setAutoApproveTypesStr(String autoApproveTypesStr) {
        this.autoApproveTypesStr = autoApproveTypesStr;
    }

    public String getZeroCostAutoApprovesStr() {
        if (EmptyUtil.isEmpty((String)this.zeroCostAutoApprovesStr) && EmptyUtil.isNotEmpty(this.getZeroCostAutoApproves())) {
            this.zeroCostAutoApprovesStr = "";
            if (this.getZeroCostAutoApproves().contains(ZERO_COST_AUTO_APPROVE_GENERAL_GOODS)) {
                this.zeroCostAutoApprovesStr = this.zeroCostAutoApprovesStr + "\u666e\u901a\u5546\u54c1,";
            }
            if (this.getZeroCostAutoApproves().contains(ZERO_COST_AUTO_APPROVE_GIFT)) {
                this.zeroCostAutoApprovesStr = this.zeroCostAutoApprovesStr + "\u8d60\u54c1,";
            }
            if (this.getZeroCostAutoApproves().contains(ZERO_COST_AUTO_APPROVE_SAMPLE_SACK)) {
                this.zeroCostAutoApprovesStr = this.zeroCostAutoApprovesStr + "\u8bd5\u7528\u88c5,";
            }
            if (this.getZeroCostAutoApproves().contains(ZERO_COST_AUTO_APPROVE_DISPLAY)) {
                this.zeroCostAutoApprovesStr = this.zeroCostAutoApprovesStr + "\u9648\u5217\u54c1,";
            }
        }
        if (this.zeroCostAutoApprovesStr == null) {
            this.zeroCostAutoApprovesStr = "";
        }
        return this.zeroCostAutoApprovesStr;
    }

    public void setZeroCostAutoApprovesStr(String zeroCostAutoApprovesStr) {
        this.zeroCostAutoApprovesStr = zeroCostAutoApprovesStr;
    }

    public List<PcsSkuAutoApproveBgmVO> getSkuAutoApproveBgms() {
        return this.skuAutoApproveBgms;
    }

    public void setSkuAutoApproveBgms(List<PcsSkuAutoApproveBgmVO> skuAutoApproveBgms) {
        this.skuAutoApproveBgms = skuAutoApproveBgms;
    }

    public List<PcsSkuAutoApproveBgmVO> getSkuAutoApproveBgmVOs() {
        return this.skuAutoApproveBgmVOs;
    }

    public void setSkuAutoApproveBgmVOs(List<PcsSkuAutoApproveBgmVO> skuAutoApproveBgmVOs) {
        this.skuAutoApproveBgmVOs = skuAutoApproveBgmVOs;
    }
}

