package com.thebeastshop.payment.vo;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.payment.enums.PPaymentChannelEnum;
import com.thebeastshop.payment.enums.PPaymentModeEnum;
import com.thebeastshop.payment.enums.PPaymentStatusEnum;
import com.thebeastshop.payment.enums.PTransTypeEnum;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 支付流水
 *
 * @author Paul-xiong
 * @date 2017年11月10日
 * @description 支付交易信息
 */
public class PPaymentTradeVO extends BaseDO implements PTrade {

    /**
     *
     */
    private static final long serialVersionUID = 1L;
    /**
     * 支付流水ID
     */
    private Long id;
    /**
     * 支付流水号
     */
    private String tradeCode;
    /**
     * 支付业务编码
     */
    private String paymentBusinessCode;
    /**
     * 订单号
     */
    private String outTradeCode;
    /**
     * 第三方支付流水号
     */
    private String thirdPartyTradeCode;
    /**
     * 渠道号
     */
    private String channelCode;
    /**
     * 会员ID
     */
    private Long memberId;
    /**
     * 访问来源
     */
    private AccessWayEnum accessWay;
    /**
     * 交易类型
     */
    private PTransTypeEnum transType;
    /**
     * 订单金额
     */
    private BigDecimal orderAmount;
    /**
     * 应付金额
     */
    private BigDecimal paymentAmount;
    /**
     * 银行方优惠金额
     */
    private BigDecimal discountAmount;
    /**
     * 实际支付金额
     */
    private BigDecimal actualPaymentAmount;
    /**
     * 支付渠道
     */
    private PPaymentChannelEnum paymentChannel;
    /**
     * 支付模式
     */
    private PPaymentModeEnum paymentMode;
    /**
     * 支付请求文本
     */
    private String requestText;
    /**
     * 支付状态
     */
    private PPaymentStatusEnum status;
    /**
     * 第三方返回信息
     */
    private String responseText;
    /**
     * 错误码
     */
    private String errorCode;
    /**
     * 第三方返回状态
     */
    private String thirdPartyRespStatus;
    /**
     * 第三方错误码
     */
    private String thirdPartyErrorCode;
    /**
     * 第三方类型
     */
    private Integer thirdPartyType;
    /**
     * 备注
     */
    private String remark;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 回调时间
     */
    private Date returnTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 币种
     */
    private String currency;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getTradeCode() {
        return tradeCode;
    }

    public void setTradeCode(String tradeCode) {
        this.tradeCode = tradeCode;
    }

    public String getPaymentBusinessCode() {
        return paymentBusinessCode;
    }

    public void setPaymentBusinessCode(String paymentBusinessCode) {
        this.paymentBusinessCode = paymentBusinessCode;
    }

    @Override
    public String getOutTradeCode() {
        return outTradeCode;
    }

    public void setOutTradeCode(String outTradeCode) {
        this.outTradeCode = outTradeCode;
    }

    @Override
    public String getThirdPartyTradeCode() {
        return thirdPartyTradeCode;
    }

    public void setThirdPartyTradeCode(String thirdPartyTradeCode) {
        this.thirdPartyTradeCode = thirdPartyTradeCode;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    @Override
    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public AccessWayEnum getAccessWay() {
        return accessWay;
    }

    public void setAccessWay(AccessWayEnum accessWay) {
        this.accessWay = accessWay;
    }

    public PTransTypeEnum getTransType() {
        return transType;
    }

    public void setTransType(PTransTypeEnum transType) {
        this.transType = transType;
    }

    @Override
    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public PPaymentChannelEnum getPaymentChannel() {
        return paymentChannel;
    }

    public void setPaymentChannel(PPaymentChannelEnum paymentChannel) {
        this.paymentChannel = paymentChannel;
    }

    public PPaymentModeEnum getPaymentMode() {
        return paymentMode;
    }

    public void setPaymentMode(PPaymentModeEnum paymentMode) {
        this.paymentMode = paymentMode;
    }

    public String getRequestText() {
        return requestText;
    }

    public void setRequestText(String requestText) {
        this.requestText = requestText;
    }

    public PPaymentStatusEnum getStatus() {
        return status;
    }

    public void setStatus(PPaymentStatusEnum status) {
        this.status = status;
    }

    public String getResponseText() {
        return responseText;
    }

    public void setResponseText(String responseText) {
        this.responseText = responseText;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public String getThirdPartyRespStatus() {
        return thirdPartyRespStatus;
    }

    public void setThirdPartyRespStatus(String thirdPartyRespStatus) {
        this.thirdPartyRespStatus = thirdPartyRespStatus;
    }

    @Override
    public String getThirdPartyErrorCode() {
        return thirdPartyErrorCode;
    }

    public void setThirdPartyErrorCode(String thirdPartyErrorCode) {
        this.thirdPartyErrorCode = thirdPartyErrorCode;
    }

    @Override
    public Integer getThirdPartyType() {
        return thirdPartyType;
    }

    public void setThirdPartyType(Integer thirdPartyType) {
        this.thirdPartyType = thirdPartyType;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getReturnTime() {
        return returnTime;
    }

    public void setReturnTime(Date returnTime) {
        this.returnTime = returnTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public BigDecimal getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    public BigDecimal getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public BigDecimal getActualPaymentAmount() {
        return actualPaymentAmount;
    }

    public void setActualPaymentAmount(BigDecimal actualPaymentAmount) {
        this.actualPaymentAmount = actualPaymentAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }
}
