package com.thebeastshop.payment.enums;

import com.thebeastshop.common.enums.CodeEnum;

/**
 * 支付模式枚举
 *
 * @author Paul-xiong
 * @date 2017年11月9日
 * @description 接口类型
 */
public enum PSqbTerminalStatusEnum implements CodeEnum<Integer> {
    VALID(1, "有效"),
    INVALID(0, "无效"),
    ;

    private Integer code;

    private String name;

    PSqbTerminalStatusEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static PSqbTerminalStatusEnum getEnumByCode(Integer code) {
        for (PSqbTerminalStatusEnum e : PSqbTerminalStatusEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

}
