package com.thebeastshop.payment.enums;

/**
 * @author Paul-xiong
 * @date 2017年11月9日
 * @description 支付状态
 */
public enum PPaymentStatusEnum {
	PAY(1, "发起支付"),
	PAYING(2, "支付中"),
	SUCCESS(3, "支付完成"),
	FAIL(-1, "支付失败"),
    CANCEL(-2, "支付撤销"),
    PAID_CANCEL(-3, "已支付撤销"),
	;

    private Integer code;

    private String name;

    PPaymentStatusEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static PPaymentStatusEnum getEnumByCode(Integer code) {
        for (PPaymentStatusEnum e : PPaymentStatusEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }
    
}
