package com.thebeastshop.payment.enums;

/**
 * 支付模式枚举
 *
 * @author Paul-xiong
 * @date 2017年11月9日
 * @description 接口类型
 */
public enum PPaymentModeEnum {
    LOCAL(1, "本地处理"),
    CLIENT(2, "客户端"),
    SERVER(3, "服务端"),
    SYSTEM(4, "系统端"),
    ;

    private Integer code;

    private String name;

    PPaymentModeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static PPaymentModeEnum getEnumByCode(Integer code) {
        for (PPaymentModeEnum e : PPaymentModeEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

}
