package com.thebeastshop.payment.dto;

import com.thebeastshop.payment.enums.PPaymentChannelEnum;

/**
 * @author Paul-xiong
 * @date 2017年12月15日
 * @description 支付宝即时支付渠道
 */
public class PAliDirectPaymentDTO extends PPaymentDTO {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 是否是扫码支付
	 */
	private Boolean isQRCodePay = false;

	/**
	 * 支付返回链接
	 */
	private String returnUrl;

	public PAliDirectPaymentDTO() {
		super(PPaymentChannelEnum.ALIPAY_DIRECT);
	}

	public Boolean getIsQRCodePay() {
		return isQRCodePay;
	}

	public void setIsQRCodePay(Boolean isQRCodePay) {
		this.isQRCodePay = isQRCodePay;
	}

	public String getReturnUrl() {
		return returnUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

}
