package com.thebeastshop.payment.enums;

import java.util.Arrays;
import java.util.List;

/**
 * 支付渠道枚举
 *
 * @author Paul-xiong
 * @date 2017年11月9日
 * @description 支付渠道
 */
public enum PRefundChannelEnum {
    // 支付宝退款渠道，注：关联的paymentChannels支付渠道是有序的。
    ALIPAY(1, "支付宝",
            PPaymentChannelEnum.ALIPAY_MOBILE,
            PPaymentChannelEnum.ALIPAY_DIRECT,
            PPaymentChannelEnum.ALIPAY_SCAN,
            PPaymentChannelEnum.ALIPAY_WAP_DIRECT,
            PPaymentChannelEnum.ALIPAY_USER_SCAN,
            PPaymentChannelEnum.ALI_BANK,
            PPaymentChannelEnum.ALI_CROSS_BORDER_MOBILE,
            PPaymentChannelEnum.ALI_CROSS_BORDER_DIRECT,
            PPaymentChannelEnum.ALI_WAP_CROSS_BORDER_DIRECT
    ),
    // 微信退款渠道，注：关联的paymentChannels支付渠道是有序的。
    WXPAY(2, "微信",
            PPaymentChannelEnum.WEIXIN_MOBILE,
            PPaymentChannelEnum.WEIXIN_MINI_PROGRAM,
            PPaymentChannelEnum.WEIXIN_SCAN,
            PPaymentChannelEnum.WEIXIN_OFFICIAL_ACCOUNT,
            PPaymentChannelEnum.WEIXIN_USER_SCAN
    ),
    CASH(3, "现金", PPaymentChannelEnum.CASH),
    DEBIT_CARD(4, "借记卡", PPaymentChannelEnum.DEBIT_CARD),
    CREDIT_CARD(5, "信用卡", PPaymentChannelEnum.CREDIT_CARD),
    TRANSFER(6, "转账", PPaymentChannelEnum.TRANSFER),
    YCK(7, "预存款", PPaymentChannelEnum.YCK),
    YEZHU(8, "业主", PPaymentChannelEnum.YEZHU),
    GIFT_CARD(9, "礼品卡", PPaymentChannelEnum.GIFT_CARD),
    INTEGRAL(10, "积分", PPaymentChannelEnum.INTEGRAL),
    CMB(11, "招商银行", PPaymentChannelEnum.CMB),
    ;

    private Integer id;

    private String name;

    /**
     * 关联的支付渠道
     */
    private List<PPaymentChannelEnum> paymentChannels;

    PRefundChannelEnum(Integer id, String name, PPaymentChannelEnum... paymentChannels) {
        this.id = id;
        this.name = name;
        if (paymentChannels == null || paymentChannels.length <= 0) {
            throw new IllegalArgumentException("退款关联的支付渠道不能为空！");
        }
        this.paymentChannels = Arrays.asList(paymentChannels);
    }

    public Integer getCode() {
        return id;
    }

    public String getName() {
        return name;
    }

    public List<PPaymentChannelEnum> getPaymentChannels() {
        return paymentChannels;
    }

    public static PRefundChannelEnum getEnumByCode(Integer code) {
        for (PRefundChannelEnum e : PRefundChannelEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }
}


