package com.thebeastshop.payment.dto;

import com.thebeastshop.payment.enums.PPaymentChannelEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * 招商银行支付渠道
 */
public class PCMBPaymentDTO extends PPaymentDTO {

    /**
     * @Field long serialVersionUID
     */
    private static final long serialVersionUID = 1L;

    /**
     * 招商银行交易流水号
     */
    private String cmdTradeCode;

    public PCMBPaymentDTO() {
        super(PPaymentChannelEnum.CMB);
    }

    public String getCmdTradeCode() {
        return cmdTradeCode;
    }

    public void setCmdTradeCode(String cmdTradeCode) {
        this.cmdTradeCode = cmdTradeCode;
    }

    @Override
    public String getPaymentBusinessCode() {
        if (StringUtils.isNotBlank(cmdTradeCode)) {
            return cmdTradeCode;
        }
        return super.getPaymentBusinessCode();
    }

}
