/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.payment.exception;

import com.thebeastshop.common.exception.BaseErrorCode;
import com.thebeastshop.payment.enums.PPaymentErrorCodeEnum;
import com.thebeastshop.payment.exception.PPaymentException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PPaymentFrequentException
extends PPaymentException {
    private Date startTime;
    private Long duration;
    private Long restDuration;
    private Map<String, Object> map = new HashMap<String, Object>();

    public PPaymentFrequentException(Date startTime, Long duration, Long restDuration) {
        super((BaseErrorCode)PPaymentErrorCodeEnum.PAYMENT_FREQUENT, "\u8bf7\u5728" + PPaymentFrequentException.time2string(restDuration) + "\u540e\u5c1d\u8bd5\u652f\u4ed8");
        this.startTime = startTime;
        this.duration = duration;
        this.restDuration = restDuration;
        this.map.put("startTime", startTime);
        this.map.put("duration", duration);
        this.map.put("restDuration", restDuration);
    }

    private static String time2string(long time) {
        if (time < 60L) {
            return time + "\u79d2";
        }
        if ((time /= 60L) < 60L) {
            return time + "\u5206\u949f";
        }
        if ((time /= 60L) < 24L) {
            return time + "\u5c0f\u65f6";
        }
        return time + "\u5929";
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Long getRestDuration() {
        return this.restDuration;
    }

    public Map<String, Object> getErrorData() {
        return this.map;
    }
}

