/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.util.cps;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.op.constant.cps.CpsCategoryType;
import com.thebeastshop.op.constant.cps.CpsCommissionType;
import com.thebeastshop.op.util.cps.CpsOrderUtil;
import com.thebeastshop.op.vo.cps.CpsOrderSkuVO;
import com.thebeastshop.op.vo.cps.CpsOrderVO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class YiQiFaOrderUtil {
    public static String createJSON(CpsOrderVO orderVO) {
        JSONObject json = new JSONObject();
        JSONArray orders = new JSONArray();
        json.put("orders", (Object)orders);
        orders.add((Object)YiQiFaOrderUtil.populateOrder(orderVO));
        return json.toString();
    }

    public static String createJSONFromList(List<CpsOrderVO> orderVOList) {
        JSONObject json = new JSONObject();
        JSONArray orders = new JSONArray();
        json.put("orders", (Object)orders);
        for (CpsOrderVO orderVO : orderVOList) {
            orders.add((Object)YiQiFaOrderUtil.populateOrder(orderVO));
        }
        return json.toString();
    }

    private static JSONObject populateOrder(CpsOrderVO orderVO) {
        JSONObject order = new JSONObject();
        JSONObject cpsData = JSON.parseObject((String)orderVO.getCpsData());
        order.put("orderNo", (Object)orderVO.getOrder_sn());
        order.put("campaignId", (Object)cpsData.getString("cid"));
        order.put("feedback", (Object)cpsData.getString("wi"));
        order.put("orderTime", (Object)DateUtil.format((Date)orderVO.getOrder_time(), (String)"yyyy-MM-dd HH:mm:ss"));
        order.put("orderStatus", (Object)orderVO.getOrder_status());
        order.put("paymentStatus", (Object)orderVO.getPaymentStatus());
        order.put("paymentType", (Object)orderVO.getPaymentType());
        order.put("updateTime", (Object)DateUtil.format((Date)orderVO.getOrder_time(), (String)"yyyy-MM-dd HH:mm:ss"));
        order.put("fare", (Object)orderVO.getFareAmount());
        order.put("favorable", (Object)orderVO.getDiscount_amount().toString());
        order.put("favorableCode", (Object)"");
        JSONArray products = new JSONArray();
        order.put("products", (Object)products);
        for (CpsOrderSkuVO orderSkuVO : orderVO.getCpsOrderSkuVOList()) {
            CpsCategoryType categoryType = CpsOrderUtil.convertToCpsCategoryType(orderSkuVO.getGoods_cate());
            CpsCommissionType commissionType = CpsOrderUtil.calculateCommissionRate(categoryType, orderSkuVO.getActualTotalPrice(), orderSkuVO.getGoods_ta());
            JSONObject product = YiQiFaOrderUtil.createJSONProduct(orderSkuVO.getGoods_id(), orderSkuVO.getGoods_name(), orderSkuVO.getGoods_ta(), orderSkuVO.getActualUnitPrice(), categoryType.getCategoryCode(), commissionType.name());
            products.add((Object)product);
        }
        return order;
    }

    public static String createJSONUpdate(CpsOrderVO orderVO) {
        JSONObject json = new JSONObject();
        JSONArray orderStatus = new JSONArray();
        JSONObject order = new JSONObject();
        json.put("orderStatus", (Object)orderStatus);
        orderStatus.add((Object)order);
        JSONObject cpsData = JSON.parseObject((String)orderVO.getCpsData());
        order.put("orderNo", (Object)orderVO.getOrder_sn());
        order.put("feedback", (Object)cpsData.getString("wi"));
        order.put("updateTime", (Object)DateUtil.format((Date)orderVO.getPaymentTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        order.put("orderStatus", (Object)orderVO.getOrder_status());
        order.put("paymentStatus", (Object)orderVO.getPaymentStatus());
        order.put("paymentType", (Object)orderVO.getPaymentType());
        return json.toJSONString();
    }

    private static JSONObject createJSONProduct(String productNo, String name, int amount, BigDecimal price, int category, String commissionType) {
        JSONObject JSONProduct = new JSONObject();
        JSONProduct.put("productNo", (Object)productNo);
        JSONProduct.put("name", (Object)name);
        JSONProduct.put("amount", (Object)amount);
        JSONProduct.put("price", (Object)price.toString());
        JSONProduct.put("category", (Object)category);
        JSONProduct.put("commissionType", (Object)commissionType);
        return JSONProduct;
    }
}

