/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.pay;

import com.thebeastshop.op.pay.AlipayHttpUtil;
import com.thebeastshop.op.pay.util.XMLBeanUtil;
import com.thebeastshop.op.pay.vo.AliPayVO;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliPayUtil {
    private static final Logger logger = LoggerFactory.getLogger(AliPayUtil.class);

    public static AliPayVO findPayMementByOrder(String orderCode, int channelType) {
        return AliPayUtil.handleParam(orderCode, channelType);
    }

    private static AliPayVO handleParam(String orderCode, int channelType) {
        AliPayVO aliPayVO = null;
        try {
            Map<String, String> params = AliPayUtil.convertAliPay(orderCode, channelType);
            String urlParam = AliPayUtil.getUrlParam(params);
            String res = AlipayHttpUtil.sendGetUrl("https://mapi.alipay.com/gateway.do?" + urlParam);
            if (StringUtils.isNotBlank((CharSequence)res)) {
                aliPayVO = XMLBeanUtil.toObject(res, AliPayVO.class);
            }
        }
        catch (Exception e) {
            logger.error("\u652f\u4ed8\u5b9d\u8c03\u7528\u9519\u8bef =e{}", (Throwable)e);
        }
        return aliPayVO;
    }

    private static String getUrlParam(Map<String, String> param) {
        String urlParam = "";
        int i = 0;
        for (Map.Entry<String, String> entry : param.entrySet()) {
            urlParam = i == 0 ? urlParam + entry.getKey() + "=" + entry.getValue() : urlParam + "&" + entry.getKey() + "=" + entry.getValue();
            ++i;
        }
        return urlParam;
    }

    private static Map<String, String> convertAliPay(String orderCode, int channelType) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (channelType == 2) {
            params.put("_input_charset", "utf-8");
            params.put("out_trade_no", orderCode);
            params.put("partner", "2088801125427095");
            params.put("service", "single_trade_query");
            params.put("sign", AliPayUtil.getSign(params, "ny4oqhaq9dr2exxrgmkrrfuz4vjnyiw9", "utf-8"));
            params.put("sign_type", "MD5");
        } else if (channelType == 3) {
            params.put("_input_charset", "utf-8");
            params.put("out_trade_no", orderCode);
            params.put("partner", "2088421407542861");
            params.put("service", "single_trade_query");
            params.put("sign", AliPayUtil.getSign(params, "o2xugjbxngkjmaampjs11gva6v2e84ll", "utf-8"));
            params.put("sign_type", "MD5");
        } else if (channelType == 4) {
            params.put("_input_charset", "utf-8");
            params.put("out_trade_no", orderCode);
            params.put("partner", "2088901791301722");
            params.put("service", "single_trade_query");
            params.put("sign", AliPayUtil.getSign(params, "dfkb1sf91yo6rmd1wmb12ca6u2q9ib4l", "utf-8"));
            params.put("sign_type", "MD5");
        }
        return params;
    }

    private static String getSign(Map<String, String> sortedParmas, String key, String inputChar) {
        String sign = "";
        String plainText = AliPayUtil.createLinkString(sortedParmas);
        sign = AliPayUtil.sign(plainText, key, inputChar);
        return sign;
    }

    private static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            prestr = i == keys.size() - 1 ? prestr + key + "=" + value : prestr + key + "=" + value + "&";
        }
        return prestr;
    }

    private static String sign(String text, String key, String input_charset) {
        text = text + key;
        return DigestUtils.md5Hex((byte[])AliPayUtil.getContentBytes(text, input_charset));
    }

    private static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset);
        }
    }
}

