/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PagingVO<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<T> dataList;
    private List<String> noList;
    @Deprecated
    private int rowCnt;
    private int totalSize;
    private int totalPage;
    private int currentPage;
    private int pageSize;
    private int offset;
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int DEFAULT_CURRENT_PAGE = 1;
    public static final int DEFAULT_CRITICAL_1 = 5;
    public static final int DEFAULT_CRITICAL_2 = 9;
    public static final int DEFAULT_CRITICAL_3 = 13;
    public static final String DEFAULT_ELIPSIS = "...";

    public PagingVO(int pageSize, int currentPage, int totalSize) {
        if (pageSize <= 0) {
            pageSize = 10;
        }
        if (currentPage <= 0) {
            currentPage = 1;
        }
        this.pageSize = pageSize;
        this.currentPage = currentPage;
        this.totalSize = totalSize;
        this.totalPage = (totalSize - 1) / pageSize + 1;
        this.rowCnt = totalSize;
        this.totalPage = (this.rowCnt - 1) / pageSize + 1;
        this.offset = pageSize * (currentPage - 1);
        this.buildPageNoList();
    }

    public PagingVO(int _pageSize, Integer _currentPage) {
        if (_pageSize <= 0) {
            _pageSize = 10;
        }
        if (_currentPage == null) {
            _currentPage = 1;
        }
        this.pageSize = _pageSize;
        this.currentPage = _currentPage;
        this.offset = this.pageSize * (this.currentPage - 1);
        this.buildPageNoList();
    }

    public void buildPageNoList() {
        this.noList = new ArrayList<String>();
        if (this.totalPage <= 5) {
            for (int i = 1; i <= this.totalPage; ++i) {
                this.noList.add(String.valueOf(i));
            }
        } else if (this.totalPage > 5 && this.totalPage <= 9) {
            if (this.currentPage < 5) {
                for (int i = 1; i <= 5; ++i) {
                    this.noList.add(String.valueOf(i));
                }
                this.noList.add(DEFAULT_ELIPSIS);
            } else {
                for (int i = 1; i <= this.totalPage; ++i) {
                    this.noList.add(String.valueOf(i));
                }
            }
        } else if (this.totalPage > 9 && this.totalPage <= 13) {
            if (this.currentPage < 5) {
                for (int i = 1; i <= 5; ++i) {
                    this.noList.add(String.valueOf(i));
                }
                this.noList.add(DEFAULT_ELIPSIS);
            } else if (this.currentPage >= 5 && this.currentPage < 9) {
                for (int i = 1; i <= 9; ++i) {
                    this.noList.add(String.valueOf(i));
                }
                this.noList.add(DEFAULT_ELIPSIS);
            } else {
                this.noList.add(String.valueOf(1));
                this.noList.add(String.valueOf(2));
                this.noList.add(DEFAULT_ELIPSIS);
                for (int i = 9; i <= this.totalPage; ++i) {
                    this.noList.add(String.valueOf(i));
                }
            }
        } else if (this.currentPage < 5) {
            for (int i = 1; i <= 5; ++i) {
                this.noList.add(String.valueOf(i));
            }
            this.noList.add(DEFAULT_ELIPSIS);
        } else if (this.currentPage >= 5 && this.currentPage < 9) {
            for (int i = 1; i <= 9; ++i) {
                this.noList.add(String.valueOf(i));
            }
            this.noList.add(DEFAULT_ELIPSIS);
        } else if (this.currentPage > this.totalPage - 5) {
            this.noList.add(String.valueOf(1));
            this.noList.add(String.valueOf(2));
            this.noList.add(DEFAULT_ELIPSIS);
            for (int i = this.totalPage - 5 + 1; i <= this.totalPage; ++i) {
                this.noList.add(String.valueOf(i));
            }
        } else if (this.currentPage <= this.totalPage - 5) {
            this.noList.add(String.valueOf(1));
            this.noList.add(String.valueOf(2));
            this.noList.add(DEFAULT_ELIPSIS);
            for (int i = this.currentPage; i < this.currentPage + 5; ++i) {
                this.noList.add(String.valueOf(i));
            }
            this.noList.add(DEFAULT_ELIPSIS);
        }
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<T> dataList) {
        this.dataList = dataList;
    }

    public List<String> getNoList() {
        return this.noList;
    }

    public void setNoList(List<String> noList) {
        this.noList = noList;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Deprecated
    public int getRowCnt() {
        return this.rowCnt;
    }

    @Deprecated
    public void setRowCnt(int rowCnt) {
        this.setTotalSize(rowCnt);
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
        this.totalPage = (totalSize - 1) / this.pageSize + 1;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("dataList", this.dataList).append("noList", this.noList).append("rowCnt", this.rowCnt).append("totalSize", this.totalSize).append("totalPage", this.totalPage).append("currentPage", this.currentPage).append("pageSize", this.pageSize).append("offset", this.offset).toString();
    }
}

