/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum CurrencyCodeEnum {
    CNY("CNY", "\u4eba\u6c11\u5e01"),
    AUD("AUD", "\u6fb3\u5143"),
    EUR("EUR", "\u6b27\u5143"),
    GBP("GBP", "\u82f1\u9551"),
    JPY("JPY", "\u65e5\u5143"),
    USD("USD", "\u7f8e\u5143"),
    KRW("KRW", "\u97e9\u5143"),
    CAD("CAD", "\u52a0\u5143"),
    CHF("CHF", "\u745e\u58eb\u6cd5\u90ce"),
    FRF("FRF", "\u6cd5\u56fd\u6cd5\u90ce"),
    SEK("SEK", "\u745e\u5178\u514b\u6717"),
    SGD("SGD", "\u65b0\u52a0\u5761\u5143"),
    ANG("ANG", "\u8377\u5170\u76fe"),
    DEM("DEM", "\u5fb7\u56fd\u9a6c\u514b"),
    HKD("HKD", "\u6e2f\u5e01"),
    MOP("MOP", "\u6fb3\u95e8\u5143"),
    THB("THB", "\u6cf0\u94e2"),
    VND("VND", "\u8d8a\u5357\u76fe");

    private String code;
    private String name;
    public static final List<CurrencyCodeEnum> ALL_ENUMS;

    private CurrencyCodeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static CurrencyCodeEnum getEnumByCode(String code) {
        for (CurrencyCodeEnum e : CurrencyCodeEnum.values()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        return null;
    }

    public static String getNameByCode(String code) {
        CurrencyCodeEnum e = CurrencyCodeEnum.getEnumByCode(code);
        if (e != null) {
            return e.getName();
        }
        return "";
    }

    public static CurrencyCodeEnum getEnumByName(String name) {
        for (CurrencyCodeEnum e : CurrencyCodeEnum.values()) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public static String getCodeByName(String name) {
        CurrencyCodeEnum e = CurrencyCodeEnum.getEnumByName(name);
        if (e != null) {
            return e.getCode();
        }
        return "";
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static {
        ALL_ENUMS = Collections.unmodifiableList(Arrays.asList(CurrencyCodeEnum.values()));
    }
}

