/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.ebay.util;

import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Sign {
    private static final Logger logger = LoggerFactory.getLogger(MD5Sign.class);
    private static String INPUT_CHARSET_UTF8 = "UTF-8";

    public static Map<String, Object> sortMapByKey(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        TreeMap<String, Object> sortMap = new TreeMap<String, Object>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        sortMap.putAll(params);
        return sortMap;
    }

    public static String buildParamsStr(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            sb.append(String.valueOf(entry.getKey()) + String.valueOf(entry.getValue()));
        }
        return sb.toString();
    }

    public static String insertSecretKey(String text, String secretKey) {
        return new StringBuffer(text).insert(0, secretKey).toString();
    }

    public static String sign(Map<String, Object> params, String secretKey) {
        String paramsStr = MD5Sign.insertSecretKey(MD5Sign.buildParamsStr(MD5Sign.sortMapByKey(params)), secretKey);
        String signature = DigestUtils.md5Hex((byte[])MD5Sign.getContentBytes(paramsStr, INPUT_CHARSET_UTF8));
        logger.debug("\u52a0\u7b7e: {}", (Object)signature);
        return signature;
    }

    public static boolean verify(String signature, Map<String, Object> params, String secretKey) {
        String paramsStr = MD5Sign.insertSecretKey(MD5Sign.buildParamsStr(MD5Sign.sortMapByKey(params)), secretKey);
        String calculateSign = DigestUtils.md5Hex((byte[])MD5Sign.getContentBytes(paramsStr, INPUT_CHARSET_UTF8));
        boolean verify = calculateSign.equals(signature);
        logger.debug("\u7cfb\u7edf\u751f\u6210\u7684\u7b7e\u540d\uff1a:{}", (Object)calculateSign);
        logger.debug("\u9a8c\u7b7e: {}", (Object)signature);
        logger.debug("\u9a8c\u7b7e\u7ed3\u679c: {}", (Object)verify);
        return verify;
    }

    private static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset);
        }
    }

    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String data = "";
        data = "{\\\"acturalPaid\\\":0.09,\\\"buyerBillTime\\\":\\\"2017-05-22 14:41:22.0\\\",\\\"buyerIdCode\\\":\\\"411327199108184927\\\",\\\"buyerIdType\\\":\\\"1\\\",\\\"buyerName\\\":\\\"\u5f20\u8fea\\\",\\\"buyerPayerCheck\\\":\\\"1\\\",\\\"buyerTel\\\":\\\"18321778153\\\",\\\"consigneeAddress\\\":\\\"\u5317\u4eac\u4e1c\u8def11\u53f7\\\",\\\"consigneeCity\\\":\\\"\u90d1\u5dde\u5e02\\\",\\\"consigneeCityCode\\\":\\\"410100\\\",\\\"consigneeDistrict\\\":\\\"\u4e8c\u4e03\u533a\\\",\\\"consigneeDistrictCode\\\":\\\"410103\\\",\\\"consigneeMob\\\":\\\"18321778153\\\",\\\"consigneeName\\\":\\\"\u5f20\u8fea\\\",\\\"consigneeProvince\\\":\\\"\u6cb3\u5357\u7701\\\",\\\"consigneeProvinceCode\\\":\\\"410000\\\",\\\"consigneeZipCode\\\":\\\"11\\\",\\\"cusOrderSucceeded\\\":\\\"0\\\",\\\"cusPaymentSucceeded\\\":\\\"0\\\",\\\"declExprFee\\\":0,\\\"declPostTax\\\":0,\\\"exprAgreementType\\\":\\\"00\\\",\\\"exprCompId\\\":\\\"sf\\\",\\\"exprType\\\":\\\"11\\\",\\\"merchId\\\":\\\"mhbs996643550862512128\\\",\\\"merchOrderId\\\":\\\"SO0120490001951860\\\",\\\"payEntCusCode\\\":\\\"7682254500\\\",\\\"payNo\\\":\\\"2017052221001003130326434636\\\",\\\"paySucceeded\\\":\\\"0\\\",\\\"payTime\\\":\\\"2017-05-22 14:41:38.0\\\",\\\"payerIdCode\\\":\\\"411327199108184927\\\",\\\"payerIdType\\\":\\\"1\\\",\\\"payerMob\\\":\\\"18321778153\\\",\\\"payerName\\\":\\\"\u5f20\u8fea\\\",\\\"remark\\\":\\\"\\\",\\\"shopId\\\":\\\"wbsp996672371355553792\\\",\\\"transMode\\\":\\\"20\\\"}";
        map.put("data", data);
        Long timeStamp = new Date().getTime() / 1000L;
        map.put("timestamp", timeStamp.toString());
        map.put("merchId", "mhbs996643550862512128");
        String si = MD5Sign.sign(map, "hzxCjtGlY9d5AJj9");
        MD5Sign.verify(si, map, "hzxCjtGlY9d5AJj9");
    }
}

