/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.pay;

import com.thebeastshop.op.pay.util.MD5Util;
import com.thebeastshop.op.pay.util.WeiXinPayHttpUtil;
import com.thebeastshop.op.pay.util.XMLBeanUtil;
import com.thebeastshop.op.pay.vo.WeiXinVO;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiXinPayUtil {
    private static final Logger logger = LoggerFactory.getLogger(WeiXinPayUtil.class);

    public static WeiXinVO findPayMementByOrder(String orderCode, int payFlg) {
        return WeiXinPayUtil.handleParam(orderCode, payFlg);
    }

    public static void main(String[] args) {
        WeiXinVO w = WeiXinPayUtil.findPayMementByOrder("SO0120180001900991", 2);
        System.out.println(w);
    }

    private static WeiXinVO handleParam(String orderCode, int payFlg) {
        WeiXinVO weiXinVO = null;
        try {
            TreeMap<String, String> param = WeiXinPayUtil.convertParamMap(orderCode, payFlg);
            String xmlStringParam = WeiXinPayUtil.convertXmlString(param);
            String resultR = WeiXinPayHttpUtil.sendPostWei(xmlStringParam);
            if (StringUtils.isNotBlank((CharSequence)resultR)) {
                weiXinVO = XMLBeanUtil.toObject(resultR, WeiXinVO.class);
            }
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38 e={}", (Throwable)e);
        }
        return weiXinVO;
    }

    private static TreeMap<String, String> convertParamMap(String orderCode, int payFlg) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (payFlg == 1) {
            treeMap.put("appid", "wx29e84033eae3cd0f");
            treeMap.put("mch_id", "1382997102");
            treeMap.put("nonce_str", WeiXinPayUtil.getNonceStr());
            treeMap.put("out_trade_no", orderCode);
        } else if (payFlg == 3) {
            treeMap.put("appid", "wxbce29784bdd01454");
            treeMap.put("mch_id", "1217660101");
            treeMap.put("nonce_str", WeiXinPayUtil.getNonceStr());
            treeMap.put("out_trade_no", orderCode);
        } else {
            treeMap.put("appid", "wxbce29784bdd01454");
            treeMap.put("mch_id", "1217660101");
            treeMap.put("nonce_str", WeiXinPayUtil.getNonceStr());
            treeMap.put("out_trade_no", orderCode);
        }
        treeMap.put("sign", WeiXinPayUtil.getSign(treeMap, payFlg));
        return treeMap;
    }

    public static String convertXmlString(TreeMap<String, String> args) {
        StringBuilder xml = new StringBuilder();
        xml.append("<xml>\n");
        for (Map.Entry<String, String> entry : args.entrySet()) {
            xml.append("<" + entry.getKey() + ">").append(entry.getValue()).append("</" + entry.getKey() + ">\n");
        }
        xml.append("</xml>");
        return xml.toString();
    }

    private static String getNonceStr() {
        return MD5Util.MD5(System.currentTimeMillis() + "");
    }

    private static String getSign(TreeMap<String, String> args, int payFlg) {
        String res = "";
        String stringA = "appid=" + args.get("appid") + "&mch_id=" + args.get("mch_id") + "&nonce_str=" + args.get("nonce_str") + "&out_trade_no=" + args.get("out_trade_no");
        if (payFlg == 1) {
            String stringSignTemp = stringA + "&key=" + "WWxoU01HSklRbmRsU0UxdGRIUnNjSEI0";
            res = MD5Util.MD5(stringSignTemp).toUpperCase();
        } else if (payFlg == 3) {
            String stringSignTemp = stringA + "&key=" + "160e84d8237f51d5b02b51356478a267";
            res = MD5Util.MD5(stringSignTemp).toUpperCase();
        } else {
            String stringSignTemp = stringA + "&key=" + "160e84d8237f51d5b02b51356478a267";
            res = MD5Util.MD5(stringSignTemp).toUpperCase();
        }
        return res;
    }

    public static String getSign(Object object, String key) throws Exception {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : WeiXinPayUtil.getSortedValueMap(object).entrySet()) {
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append('&');
        }
        builder.append("key=").append(key);
        return DigestUtils.md5Hex((String)builder.toString());
    }

    private static Map<String, String> getSortedValueMap(Object object) throws Exception {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String value = field.get(object).toString();
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            map.put(field.getName(), value);
        }
        return map;
    }

    public static String sendToWX(HttpPost httpPost, String data) throws IOException {
        StringEntity entity = new StringEntity(data, "UTF-8");
        httpPost.addHeader("Content-Type", "text/xml");
        httpPost.setEntity((HttpEntity)entity);
        return EntityUtils.toString((HttpEntity)HttpClients.createDefault().execute((HttpUriRequest)httpPost).getEntity(), (String)"UTF-8");
    }
}

