/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.vo;

import com.thebeastshop.common.utils.NullUtil;
import com.thebeastshop.op.vo.OpSoPackageDeliveryInfoVO;
import com.thebeastshop.op.vo.OpSoPackageSkuVO;
import com.thebeastshop.op.vo.OpSoPackageSkuWhComputeInfo;
import com.thebeastshop.op.vo.OpSoPackageVO;
import com.thebeastshop.op.vo.OpSplitPackageVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OpSoPackageWhComputeInfo
implements Serializable {
    private Map<String, Integer> skuQuantityMap;
    private OpSoPackageVO sourcePackage;
    private List<OpSplitPackageVO> splitPackageList;
    private List<OpSoPackageSkuWhComputeInfo> splitInfoList;
    private Long districtId;

    public OpSoPackageWhComputeInfo(OpSoPackageVO sourcePackage) {
        this.sourcePackage = sourcePackage;
        this.skuQuantityMap = sourcePackage.getOpSoPackageSkuVOList().stream().collect(Collectors.groupingBy(OpSoPackageSkuVO::getSkuCode, Collectors.summingInt(OpSoPackageSkuVO::getQuantity)));
        OpSoPackageDeliveryInfoVO deliveryInfo = sourcePackage.getOpSoPackageDeliveryInfo();
        if (NullUtil.isNotNull((Object)deliveryInfo)) {
            this.districtId = deliveryInfo.getDistrictId();
        }
    }

    public boolean isSinglePackageSku() {
        return this.skuQuantityMap.size() == 1;
    }

    public Map<String, Integer> getSkuQuantityMap() {
        return new HashMap<String, Integer>(this.skuQuantityMap);
    }

    public List<String> getSkuCodes() {
        return new ArrayList<String>(this.skuQuantityMap.keySet());
    }

    public OpSoPackageVO getSourcePackage() {
        return this.sourcePackage;
    }

    public List<OpSplitPackageVO> getSplitPackageList() {
        return this.splitPackageList;
    }

    public void setSplitPackageList(List<OpSplitPackageVO> splitPackageList) {
        this.splitPackageList = splitPackageList;
    }

    public Long getDistrictId() {
        return this.districtId;
    }
}

