/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.mbgw.sdk.enums;

import java.util.Arrays;
import java.util.Optional;

public enum OrderStatusEnum {
    ALLOCATING(2, "\u914d\u8d27\u4e2d", true),
    SHIPPED(3, "\u5df2\u53d1\u8d27", false),
    COMPLETED(4, "\u5df2\u5b8c\u6210", false),
    CANCELED(5, "\u5df2\u4f5c\u5e9f", false),
    ALL_UNSHIPPED(6, "\u6240\u6709\u672a\u53d1\u8d27", true),
    ALL_SHIPPED(7, "\u6240\u6709\u975e\u672a\u53d1\u8d27", false);

    private final int code;
    private final String desc;
    private final boolean unshipped;

    private OrderStatusEnum(int code, String desc, boolean unshipped) {
        this.code = code;
        this.desc = desc;
        this.unshipped = unshipped;
    }

    public static Optional<OrderStatusEnum> getByCode(int code) {
        return Arrays.stream(OrderStatusEnum.values()).filter(status -> status.code == code).findFirst();
    }

    public boolean isUnshipped() {
        return this.unshipped;
    }

    public boolean isShippedOrLater() {
        return !this.unshipped;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

