/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.mbgw.sdk.client;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.mbgw.sdk.client.MbGwClient;
import com.thebeastshop.mbgw.sdk.config.MbGwSdkConfig;
import com.thebeastshop.mbgw.sdk.request.MbGwRequest;
import com.thebeastshop.mbgw.sdk.response.MbGwResponse;
import com.thebeastshop.mbgw.sdk.util.MbGwHttpUtil;
import com.thebeastshop.mbgw.sdk.util.MbGwLogUtil;
import com.thebeastshop.mbgw.sdk.util.MbGwSignUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class MbGwClientImpl
implements MbGwClient {
    private static final Logger log = MbGwLogUtil.getLogger(MbGwClientImpl.class);

    @Override
    public <T> MbGwResponse<T> execute(MbGwRequest request, Class<T> dataType) {
        long startTime = System.currentTimeMillis();
        String apiName = request.getApiName();
        log.info("\u5f00\u59cb\u8c03\u7528API\uff1a{}\uff08\u8bf7\u6c42ID\uff1a{}\uff09", (Object)apiName, (Object)System.currentTimeMillis());
        try {
            String responseJson;
            HashMap<String, Object> textParams = new HashMap<String, Object>();
            HashMap<String, String> fileParams = new HashMap<String, String>();
            boolean hasFile = this.splitParams(request.getParams(), textParams, fileParams);
            log.info("API[{}]\u53c2\u6570\u62c6\u5206\u5b8c\u6210\uff1a\u6587\u672c\u53c2\u6570{}\u4e2a\uff0c\u6587\u4ef6\u53c2\u6570{}\u4e2a", new Object[]{apiName, textParams.size(), fileParams.size()});
            Map<String, Object> baseParams = this.buildBaseParams(request, textParams);
            String requestJson = JSON.toJSONString(baseParams);
            log.info("API[{}]\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)apiName, (Object)requestJson);
            String sign = MbGwSignUtil.generateSign(requestJson);
            log.info("API[{}]\u7b7e\u540d\u751f\u6210\u5b8c\u6210\uff1a{}", (Object)apiName, (Object)(sign.substring(0, 10) + "..."));
            if (hasFile) {
                HashMap<String, String> formTextParams = new HashMap<String, String>();
                baseParams.forEach((k, v) -> formTextParams.put((String)k, v.toString()));
                responseJson = MbGwHttpUtil.sendFormPost(formTextParams, fileParams, sign);
                log.info("API[{}]\u6587\u4ef6\u4e0a\u4f20\u8bf7\u6c42\u53d1\u9001\u5b8c\u6210", (Object)apiName);
            } else {
                responseJson = MbGwHttpUtil.sendJsonPost(requestJson, sign);
                log.info("API[{}]JSON\u8bf7\u6c42\u53d1\u9001\u5b8c\u6210", (Object)apiName);
            }
            log.info("API[{}]\u539f\u59cb\u54cd\u5e94\uff1a{}", (Object)apiName, (Object)responseJson);
            MbGwResponse<T> response = MbGwResponse.parse(responseJson, dataType);
            long costTime = System.currentTimeMillis() - startTime;
            if (response.isSuccess()) {
                log.info("API[{}]\u8c03\u7528\u6210\u529f\uff08\u8017\u65f6\uff1a{}ms\uff0c\u54cd\u5e94\u7801\uff1a{}\uff09", new Object[]{apiName, costTime, response.getCode()});
            } else {
                log.warn("API[{}]\u8c03\u7528\u5931\u8d25\uff08\u8017\u65f6\uff1a{}ms\uff0c\u54cd\u5e94\u7801\uff1a{}\uff0c\u4fe1\u606f\uff1a{}\uff09", new Object[]{apiName, costTime, response.getCode(), response.getMessage()});
            }
            return response;
        }
        catch (Exception e) {
            long costTime = System.currentTimeMillis() - startTime;
            log.error("API[{}]\u8c03\u7528\u5f02\u5e38\uff08\u8017\u65f6\uff1a{}ms\uff09", new Object[]{apiName, costTime, e});
            throw e;
        }
    }

    private boolean splitParams(Map<String, Object> params, Map<String, Object> textParams, Map<String, String> fileParams) {
        boolean hasFile = false;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String && ((String)value).startsWith("@")) {
                String filePath = ((String)value).substring(1);
                fileParams.put(key, filePath);
                hasFile = true;
                continue;
            }
            textParams.put(key, value);
        }
        return hasFile;
    }

    private Map<String, Object> buildBaseParams(MbGwRequest request, Map<String, Object> textParams) {
        HashMap<String, Object> baseParams = new HashMap<String, Object>();
        baseParams.put("api", request.getApiName());
        baseParams.put("appkey", MbGwSdkConfig.getApiKey());
        baseParams.put("accesstoken", request.getAccessToken());
        baseParams.put("data", textParams);
        baseParams.put("timestamp", System.currentTimeMillis() / 1000L);
        return baseParams;
    }
}

