package com.thebeastshop.mbgw.sdk.util;


import com.thebeastshop.mbgw.sdk.config.MbGwSdkConfig;
import org.slf4j.Logger;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class MbGwSignUtil {
    private static final Logger log = MbGwLogUtil.getLogger(MbGwSignUtil.class);
    private static final String ALGORITHM = "HmacSHA256";

    public static String generateSign(String data) {
        log.debug("开始生成签名（数据长度：{}）", data.length());
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            SecretKeySpec keySpec = new SecretKeySpec(
                    MbGwSdkConfig.getApiToken().getBytes(StandardCharsets.UTF_8),
                    ALGORITHM
            );
            mac.init(keySpec);

            byte[] signBytes = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
            StringBuilder signBuilder = new StringBuilder();
            for (byte b : signBytes) {
                signBuilder.append(String.format("%02x", b));
            }
            log.debug("签名生成成功");
            return signBuilder.toString();
        } catch (NoSuchAlgorithmException | InvalidKeyException e) {
            log.error("签名生成失败", e);
            throw new RuntimeException("签名生成失败", e);
        }
    }
}