package com.thebeastshop.mbgw.sdk.util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * SDK日志工具类
 * 统一管理日志对象，避免重复创建
 */
public class MbGwLogUtil {
    // 按类名获取Logger（性能更优）
    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz);
    }

    // 简化获取当前类Logger的方法（通过栈轨迹获取调用类）
    public static Logger getCurrentLogger() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        // 栈索引2：调用者的类
        String className = stack[2].getClassName();
        try {
            return LoggerFactory.getLogger(Class.forName(className));
        } catch (ClassNotFoundException e) {
            return LoggerFactory.getLogger(className);
        }
    }
}
