/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.mbgw.sdk.util;

import com.thebeastshop.mbgw.sdk.config.MbGwSdkConfig;
import com.thebeastshop.mbgw.sdk.util.MbGwLogUtil;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;

public class MbGwSignUtil {
    private static final Logger log = MbGwLogUtil.getLogger(MbGwSignUtil.class);
    private static final String ALGORITHM = "HmacSHA256";

    public static String generateSign(String data) {
        log.debug("\u5f00\u59cb\u751f\u6210\u7b7e\u540d\uff08\u6570\u636e\u957f\u5ea6\uff1a{}\uff09", (Object)data.length());
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            SecretKeySpec keySpec = new SecretKeySpec(MbGwSdkConfig.getApiToken().getBytes(StandardCharsets.UTF_8), ALGORITHM);
            mac.init(keySpec);
            byte[] signBytes = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
            StringBuilder signBuilder = new StringBuilder();
            for (byte b : signBytes) {
                signBuilder.append(String.format("%02x", b));
            }
            log.debug("\u7b7e\u540d\u751f\u6210\u6210\u529f");
            return signBuilder.toString();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("\u7b7e\u540d\u751f\u6210\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u7b7e\u540d\u751f\u6210\u5931\u8d25", e);
        }
    }
}

