package com.thebeastshop.mbgw.sdk.response;


import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.util.List;

/**
 * 订单列表查询响应模型
 * 对应接口：order-get-list
 * 封装分页信息和订单列表数据
 */
public class OrderListResponse extends MbGwResponse<OrderListResponse.Data> {

    /**
     * 响应数据内部类（封装分页和订单列表）
     */
    public static class Data implements Serializable {
        private static final long serialVersionUID = -4784157842481104523L;
        @JSONField(name = "total")
        private Integer total; // 总条数

        @JSONField(name = "hasNext")
        private boolean hasNext; // 是否有下一页

        @JSONField(name = "nextCursor")
        private String nextCursor; // 每页条数


        @JSONField(name = "data")
        private List<String> orderList; // 订单列表

        // Getter和Setter
        public Integer getTotal() { return total; }
        public void setTotal(Integer total) { this.total = total; }


        public List<String> getOrderList() {
            return orderList;
        }

        public void setOrderList(List<String> orderList) {
            this.orderList = orderList;
        }

        public boolean isHasNext() {
            return hasNext;
        }

        public void setHasNext(boolean hasNext) {
            this.hasNext = hasNext;
        }

        public String getNextCursor() {
            return nextCursor;
        }

        public void setNextCursor(String nextCursor) {
            this.nextCursor = nextCursor;
        }
    }



    public static OrderListResponse parse(String json) {
        // 调用父类解析方法，明确：
        // 1. 响应类型 R = OrderListResponse
        // 2. 数据类型 D = OrderListResponse.Data
        return MbGwResponse.parse(json, OrderListResponse.class, Data.class);
    }


    /**
     * 获取订单列表数据（简化调用）
     */
    public List<String> getOrderList() {
        return getData() != null ? getData().getOrderList() : null;
    }

    /**
     * 获取总条数（简化调用）
     */
    public Integer getTotalCount() {
        return getData() != null ? getData().getTotal() : 0;
    }
}
