package com.thebeastshop.mbgw.sdk.response;


import java.io.Serializable;

/**
 * 马帮ERP 订单发货响应
 * 对应接口：order-do-deliver-order（与请求类接口名一致）
 * 解析发货接口返回的响应数据，包含发货状态、结果描述等
 */
public class DeliverOrderResponse extends MbGwResponse<DeliverOrderResponse.Data> {

    private static final long serialVersionUID = 5443459144964411859L;

    /**
     * 发货响应业务数据内部类
     * 封装订单发货的核心结果信息
     */
    public static class Data implements Serializable {

    }

    /**
     * 解析原始JSON响应字符串为OrderShipResponse对象
     * @param json 接口返回的原始JSON
     * @return 解析后的发货响应对象
     */
    public static DeliverOrderResponse parse(String json) {
        return MbGwResponse.parse(json, DeliverOrderResponse.class, DeliverOrderResponse.Data.class);
    }

    /**
     * 便捷方法：判断发货是否成功
     * @return true-发货成功，false-发货失败（含接口调用失败）
     */
    public boolean isShipSuccess() {
        // 先判断接口调用是否成功（父类方法），再判断业务状态
        return isSuccess();
    }

}
